/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.decorator;

import java.util.Objects;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.decorator.DecoratorInformation;

public class VpnDecoratorInformation
implements DecoratorInformation {
    private final IP rangeStart;
    private final IP rangeEnd;
    private final int numberOfMatches;

    public VpnDecoratorInformation(IP rangeStart, IP rangeEnd, int numberOfMatches) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.numberOfMatches = numberOfMatches;
    }

    public VpnDecoratorInformation(IP rangeStart, IP rangeEnd) {
        this(rangeStart, rangeEnd, 1);
    }

    @Override
    public IP getRangeStart() {
        return this.rangeStart;
    }

    @Override
    public IP getRangeEnd() {
        return this.rangeEnd;
    }

    @Override
    public int getNumberOfMatches() {
        return this.numberOfMatches;
    }

    public VpnDecoratorInformation withNewRange(IP start, IP end) {
        return new VpnDecoratorInformation(start, end, this.numberOfMatches);
    }

    public VpnDecoratorInformation withNumberOfMatches(int i) {
        return new VpnDecoratorInformation(this.rangeStart, this.rangeEnd, i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VpnDecoratorInformation that = (VpnDecoratorInformation)o;
        return this.numberOfMatches == that.numberOfMatches && Objects.equals(this.rangeStart, that.rangeStart) && Objects.equals(this.rangeEnd, that.rangeEnd);
    }

    public int hashCode() {
        return Objects.hash(this.rangeStart, this.rangeEnd, this.numberOfMatches);
    }

    public String toString() {
        return "VpnDecoratorInformation{rangeStart=" + String.valueOf(this.rangeStart) + ", rangeEnd=" + String.valueOf(this.rangeEnd) + ", numberOfMatches=" + this.numberOfMatches + "}";
    }
}

