/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.building.mmdb.maxmind;

import com.maxmind.db.MaxMindDbConstructor;
import com.maxmind.db.MaxMindDbParameter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import technology.dice.dicewhere.building.mmdb.CityResult;
import technology.dice.dicewhere.building.mmdb.maxmind.MaxmindCityDetails;
import technology.dice.dicewhere.building.mmdb.maxmind.MaxmindCountry;
import technology.dice.dicewhere.building.mmdb.maxmind.MaxmindSubdivisionsDetails;

public class MaxmindCityResult
implements CityResult {
    private static final String LOCALE = "en";
    private final MaxmindCountry country;
    private final MaxmindCityDetails city;
    private final Map<String, String> postal;
    private final ArrayList<MaxmindSubdivisionsDetails> subdivisions;

    @MaxMindDbConstructor
    public MaxmindCityResult(@MaxMindDbParameter(name="country") MaxmindCountry country, @MaxMindDbParameter(name="city") MaxmindCityDetails city, @MaxMindDbParameter(name="postal") Map<String, String> postal, @MaxMindDbParameter(name="subdivisions") ArrayList<MaxmindSubdivisionsDetails> subdivisions) {
        this.country = country;
        this.city = city;
        this.postal = postal;
        this.subdivisions = subdivisions;
    }

    @Override
    public String country() {
        return Optional.ofNullable(this.country).map(c -> c.getIsoCode()).orElse(null);
    }

    @Override
    public String city() {
        return Optional.ofNullable(this.city).map(c -> c.name(LOCALE)).orElse(null);
    }

    @Override
    public String postal() {
        return Optional.ofNullable(this.postal).map(p -> (String)p.get("code")).orElse(null);
    }

    @Override
    public String mostSpecificDivision() {
        return this.subdivisions == null || this.subdivisions.isEmpty() ? null : this.subdivisions.get(this.subdivisions.size() - 1).name(LOCALE);
    }

    @Override
    public String leastSpecificDivision() {
        return this.subdivisions == null || this.subdivisions.isEmpty() ? null : this.subdivisions.get(0).name(LOCALE);
    }

    @Override
    public String geoNameId() {
        return Optional.ofNullable(this.city).map(c -> c.geoNameId()).orElse(null);
    }
}

