/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter;

import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursorImpl;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.AbstractPartition;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.api.partition.PartitionWriteTxn;
import org.apache.directory.server.core.api.partition.Subordinates;
import org.apache.logging.log4j.core.util.UuidUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technology.openpool.ldap.adapter.api.exception.InternalServerException;
import technology.openpool.ldap.adapter.api.exception.UnsupportedQueryExpressionException;

public abstract class SimpleReadOnlyPartition
extends AbstractPartition {
    private final Logger logger = LoggerFactory.getLogger(SimpleReadOnlyPartition.class);
    private static final String MODIFICATION_NOT_ALLOWED_MSG = "This simple partition does not allow modification.";

    protected abstract boolean compare(CompareOperationContext var1) throws LdapException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EntryFilteringCursor search(SearchOperationContext context) throws LdapException {
        if (context.getSession().getClientAddress() == null) {
            return new EntryFilteringCursorImpl((Cursor)new EmptyCursor(), context, this.schemaManager);
        }
        this.logger.info("[{}] - Query: DN={} filter={} scope={}", new Object[]{context.getSession().getClientAddress(), context.getDn().getName(), context.getFilter(), context.getScope()});
        try {
            switch (context.getScope()) {
                case OBJECT: {
                    EntryFilteringCursor cursor = this.findOne(context);
                    return cursor;
                }
                case ONELEVEL: {
                    EntryFilteringCursor cursor = this.findManyOnFirstLevel(context);
                    return cursor;
                }
                case SUBTREE: {
                    EntryFilteringCursor cursor = this.findManyOnMultipleLevels(context);
                    return cursor;
                }
                default: {
                    EntryFilteringCursor cursor = new EntryFilteringCursorImpl((Cursor)new EmptyCursor(), context, this.schemaManager);
                    return cursor;
                }
            }
        }
        catch (UnsupportedQueryExpressionException e) {
            this.logger.debug("The partition caught an exception because of an unsupported filter expression.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("The partition caught an exception.", (Throwable)e);
            throw new InternalServerException("The partition has detected an internal server error.");
        }
        finally {
            this.logger.debug("[{}] - Cursor created by partition {}", (Object)context.getSession().getClientAddress(), (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    protected abstract EntryFilteringCursor findOne(SearchOperationContext var1) throws LdapException;

    protected abstract EntryFilteringCursor findManyOnFirstLevel(SearchOperationContext var1) throws LdapException;

    protected abstract EntryFilteringCursor findManyOnMultipleLevels(SearchOperationContext var1) throws LdapException;

    protected abstract void doDestroy() throws LdapException;

    protected void doDestroy(PartitionTxn partitionTxn) throws LdapException {
        this.doDestroy();
    }

    protected void doRepair() throws LdapException {
    }

    public PartitionReadTxn beginReadTransaction() {
        return new ReadTransaction();
    }

    public PartitionWriteTxn beginWriteTransaction() {
        return null;
    }

    public void unbind(UnbindOperationContext unbindOperationContext) throws LdapException {
    }

    public void saveContextCsn(PartitionTxn partitionTxn) throws LdapException {
    }

    public Subordinates getSubordinates(PartitionTxn partitionTxn, Entry entry) throws LdapException {
        return null;
    }

    public void add(AddOperationContext addOperationContext) throws LdapException {
        throw new LdapException(MODIFICATION_NOT_ALLOWED_MSG);
    }

    public void modify(ModifyOperationContext modifyOperationContext) throws LdapException {
        throw new LdapException(MODIFICATION_NOT_ALLOWED_MSG);
    }

    public Entry delete(DeleteOperationContext deleteOperationContext) throws LdapException {
        throw new LdapException(MODIFICATION_NOT_ALLOWED_MSG);
    }

    public void move(MoveOperationContext moveOperationContext) throws LdapException {
        throw new LdapException(MODIFICATION_NOT_ALLOWED_MSG);
    }

    public void rename(RenameOperationContext renameOperationContext) throws LdapException {
        throw new LdapException(MODIFICATION_NOT_ALLOWED_MSG);
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameOperationContext) throws LdapException {
        throw new LdapException(MODIFICATION_NOT_ALLOWED_MSG);
    }

    public static class ReadTransaction
    extends PartitionReadTxn {
        private final String id = UuidUtil.getTimeBasedUuid().toString();

        public String getId() {
            return this.id;
        }
    }
}

