/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.ObjectClassNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.interceptor.context.FilteringOperationContext;
import technology.openpool.ldap.adapter.api.entity.DomainEntity;
import technology.openpool.ldap.adapter.api.entity.EntityType;
import technology.openpool.ldap.adapter.api.entity.UnitEntity;
import technology.openpool.ldap.adapter.api.exception.UnsupportedQueryExpressionException;
import technology.openpool.ldap.adapter.api.query.AndLogicExpression;
import technology.openpool.ldap.adapter.api.query.BooleanValue;
import technology.openpool.ldap.adapter.api.query.EqualOperator;
import technology.openpool.ldap.adapter.api.query.NotLogicExpression;
import technology.openpool.ldap.adapter.api.query.OperatorExpression;
import technology.openpool.ldap.adapter.api.query.OrLogicExpression;
import technology.openpool.ldap.adapter.api.query.PresenceOperator;
import technology.openpool.ldap.adapter.api.query.QueryExpression;
import technology.openpool.ldap.adapter.api.query.WildcardOperator;

public class LdapUtils {
    public static final String OU_GROUPS = "groups";
    public static final String OU_USERS = "users";
    public static final String MEMBER_OF_AT = "memberOf";
    public static final String MEMBER_OF_AT_OID = "1.2.840.113556.1.2.102";

    private LdapUtils() {
    }

    public static Dn createDn(SchemaManager schemaManager, EntityType entityType, String dcId) {
        try {
            switch (entityType) {
                case DOMAIN: {
                    return new Dn(schemaManager, new String[]{String.format("dc=%s", dcId)});
                }
                case GROUP_UNIT: {
                    return new Dn(schemaManager, new String[]{String.format("ou=%s,dc=%s", OU_GROUPS, dcId)});
                }
                case USER_UNIT: {
                    return new Dn(schemaManager, new String[]{String.format("ou=%s,dc=%s", OU_USERS, dcId)});
                }
            }
            throw new IllegalArgumentException("Cannot create DN from unknown entity.");
        }
        catch (LdapInvalidDnException e) {
            throw new RuntimeException(e);
        }
    }

    public static Dn createDn(SchemaManager schemaManager, EntityType entityType, String name, String dcId) {
        try {
            switch (entityType) {
                case GROUP: {
                    return new Dn(schemaManager, new String[]{String.format("cn=%s,ou=%s,dc=%s", Rdn.escapeValue((String)name), OU_GROUPS, dcId)});
                }
                case USER: {
                    return new Dn(schemaManager, new String[]{String.format("cn=%s,ou=%s,dc=%s", Rdn.escapeValue((String)name), OU_USERS, dcId)});
                }
            }
            return LdapUtils.createDn(schemaManager, entityType, dcId);
        }
        catch (LdapInvalidDnException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getGroupIdFromDn(SchemaManager schemaManager, String dn, String dcId) {
        try {
            Dn queryDn = new Dn(schemaManager, new String[]{dn});
            String attribute = LdapUtils.normalizeAttribute(queryDn.getRdn().getType());
            if ((queryDn.getParent().equals((Object)LdapUtils.createDn(schemaManager, EntityType.GROUP_UNIT, dcId)) || queryDn.getParent().equals((Object)LdapUtils.createDn(schemaManager, EntityType.DOMAIN, dcId))) && attribute.equals("2.5.4.3")) {
                return queryDn.getRdn().getValue().toLowerCase();
            }
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            // empty catch block
        }
        return null;
    }

    public static String getUserIdFromDn(SchemaManager schemaManager, String dn, String dcId) {
        try {
            Dn queryDn = new Dn(schemaManager, new String[]{dn});
            String attribute = LdapUtils.normalizeAttribute(queryDn.getRdn().getType());
            if ((queryDn.getParent().equals((Object)LdapUtils.createDn(schemaManager, EntityType.USER_UNIT, dcId)) || queryDn.getParent().equals((Object)LdapUtils.createDn(schemaManager, EntityType.DOMAIN, dcId))) && (attribute.equals("0.9.2342.19200300.100.1.1") || attribute.equals("2.5.4.3"))) {
                return queryDn.getRdn().getValue().toLowerCase();
            }
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            // empty catch block
        }
        return null;
    }

    public static QueryExpression createQueryExpression(ExprNode node) {
        if (node instanceof AndNode) {
            return new AndLogicExpression(((AndNode)node).getChildren().stream().map(LdapUtils::createQueryExpression).collect(Collectors.toList()));
        }
        if (node instanceof OrNode) {
            return new OrLogicExpression(((OrNode)node).getChildren().stream().map(LdapUtils::createQueryExpression).collect(Collectors.toList()));
        }
        if (node instanceof NotNode) {
            return new NotLogicExpression(((NotNode)node).getChildren().stream().map(LdapUtils::createQueryExpression).collect(Collectors.toList()));
        }
        if (node instanceof EqualityNode) {
            EqualityNode n = (EqualityNode)node;
            return new EqualOperator(n.getAttribute(), n.getValue().toString());
        }
        if (node instanceof PresenceNode) {
            PresenceNode n = (PresenceNode)node;
            return new PresenceOperator(n.getAttribute());
        }
        if (node instanceof SubstringNode) {
            SubstringNode n = (SubstringNode)node;
            String initialSegment = StringUtils.stripStart((String)n.getInitial(), null);
            String finalSegment = StringUtils.stripEnd((String)n.getFinal(), null);
            ArrayList<String> middleSegments = new ArrayList<String>();
            if (n.getAny() != null) {
                middleSegments.addAll(n.getAny());
            }
            Pattern pattern = SubstringNode.getRegex((String)initialSegment, (String[])((String[])middleSegments.toArray(String[]::new)), (String)finalSegment);
            return new WildcardOperator(n.getAttribute(), pattern, initialSegment, finalSegment, middleSegments);
        }
        if (node instanceof ObjectClassNode) {
            return BooleanValue.trueValue();
        }
        throw new UnsupportedQueryExpressionException("Cannot evaluate unsupported operator.");
    }

    public static QueryExpression removeValueExpressions(QueryExpression expression) {
        if (expression instanceof AndLogicExpression) {
            List<QueryExpression> childs = ((AndLogicExpression)expression).getChildren().stream().map(LdapUtils::removeValueExpressions).filter(x -> !(x instanceof BooleanValue) || !((BooleanValue)x).getValue()).collect(Collectors.toList());
            if (childs.isEmpty()) {
                return new BooleanValue(AndLogicExpression.EMPTY_SEQ_BOOLEAN);
            }
            if (childs.stream().anyMatch(x -> x instanceof BooleanValue && !((BooleanValue)x).getValue())) {
                return BooleanValue.falseValue();
            }
            if (childs.size() == 1) {
                return (QueryExpression)childs.get(0);
            }
            return new AndLogicExpression(childs);
        }
        if (expression instanceof OrLogicExpression) {
            List<QueryExpression> childs = ((OrLogicExpression)expression).getChildren().stream().map(LdapUtils::removeValueExpressions).filter(x -> !(x instanceof BooleanValue) || ((BooleanValue)x).getValue()).collect(Collectors.toList());
            if (childs.isEmpty()) {
                return new BooleanValue(OrLogicExpression.EMPTY_SEQ_BOOLEAN);
            }
            if (childs.stream().anyMatch(x -> x instanceof BooleanValue && ((BooleanValue)x).getValue())) {
                return BooleanValue.trueValue();
            }
            if (childs.size() == 1) {
                return (QueryExpression)childs.get(0);
            }
            return new OrLogicExpression(childs);
        }
        if (expression instanceof NotLogicExpression) {
            List<QueryExpression> childs = ((NotLogicExpression)expression).getChildren().stream().map(LdapUtils::removeValueExpressions).filter(x -> !(x instanceof BooleanValue) || ((BooleanValue)x).getValue()).collect(Collectors.toList());
            if (childs.isEmpty()) {
                return new BooleanValue(NotLogicExpression.EMPTY_SEQ_BOOLEAN);
            }
            if (childs.stream().anyMatch(x -> x instanceof BooleanValue && ((BooleanValue)x).getValue())) {
                return BooleanValue.falseValue();
            }
            return new NotLogicExpression(childs);
        }
        return expression;
    }

    public static QueryExpression removeNotExpressions(QueryExpression expression) {
        if (expression instanceof AndLogicExpression) {
            if (((AndLogicExpression)expression).getChildren().size() == 1) {
                QueryExpression child = ((AndLogicExpression)expression).getChildren().get(0);
                return LdapUtils.removeNotExpressions(child);
            }
            return new AndLogicExpression(((AndLogicExpression)expression).getChildren().stream().map(LdapUtils::removeNotExpressions).collect(Collectors.toList()));
        }
        if (expression instanceof OrLogicExpression) {
            if (((OrLogicExpression)expression).getChildren().size() == 1) {
                QueryExpression child = ((OrLogicExpression)expression).getChildren().get(0);
                return LdapUtils.removeNotExpressions(child);
            }
            return new OrLogicExpression(((OrLogicExpression)expression).getChildren().stream().map(LdapUtils::removeNotExpressions).collect(Collectors.toList()));
        }
        if (expression instanceof NotLogicExpression) {
            if (((NotLogicExpression)expression).getChildren().size() == 1) {
                QueryExpression child = ((NotLogicExpression)expression).getChildren().get(0);
                if (child instanceof AndLogicExpression) {
                    return LdapUtils.removeNotExpressions(new OrLogicExpression(((AndLogicExpression)child).getChildren().stream().map(x -> new NotLogicExpression(Collections.singletonList(x))).collect(Collectors.toList())));
                }
                if (child instanceof OrLogicExpression) {
                    return LdapUtils.removeNotExpressions(new AndLogicExpression(((OrLogicExpression)child).getChildren().stream().map(x -> new NotLogicExpression(Collections.singletonList(x))).collect(Collectors.toList())));
                }
                if (child instanceof NotLogicExpression) {
                    return LdapUtils.removeNotExpressions(new OrLogicExpression(((NotLogicExpression)child).getChildren()));
                }
                if (child instanceof BooleanValue) {
                    return ((BooleanValue)child).negate();
                }
                if (child instanceof OperatorExpression) {
                    return ((OperatorExpression)child).negate();
                }
                return LdapUtils.removeNotExpressions(child);
            }
            return LdapUtils.removeNotExpressions(new AndLogicExpression(((NotLogicExpression)expression).getChildren().stream().map(x -> new NotLogicExpression(Collections.singletonList(x))).collect(Collectors.toList())));
        }
        return expression;
    }

    public static QueryExpression preEvaluateExpression(QueryExpression expression, DomainEntity entity) {
        if (expression instanceof AndLogicExpression) {
            return new AndLogicExpression(((AndLogicExpression)expression).getChildren().stream().map(x -> LdapUtils.preEvaluateExpression(x, entity)).collect(Collectors.toList()));
        }
        if (expression instanceof OrLogicExpression) {
            return new OrLogicExpression(((OrLogicExpression)expression).getChildren().stream().map(x -> LdapUtils.preEvaluateExpression(x, entity)).collect(Collectors.toList()));
        }
        if (expression instanceof NotLogicExpression) {
            return new NotLogicExpression(((NotLogicExpression)expression).getChildren().stream().map(x -> LdapUtils.preEvaluateExpression(x, entity)).collect(Collectors.toList()));
        }
        if (expression instanceof OperatorExpression) {
            OperatorExpression operator = (OperatorExpression)expression;
            switch (LdapUtils.normalizeAttribute(operator.getAttribute())) {
                case "2.5.4.0": {
                    return new BooleanValue(operator.check("domain") || operator.check("top"));
                }
                case "dc": {
                    return new BooleanValue(operator.check(entity.getId()));
                }
                case "2.5.4.13": {
                    return new BooleanValue(operator.check(entity.getDescription()));
                }
            }
            if (operator instanceof PresenceOperator) {
                return new BooleanValue(operator.isNegated());
            }
            return BooleanValue.falseValue();
        }
        return expression;
    }

    public static QueryExpression preEvaluateExpression(QueryExpression expression, UnitEntity entity) {
        if (expression instanceof AndLogicExpression) {
            return new AndLogicExpression(((AndLogicExpression)expression).getChildren().stream().map(x -> LdapUtils.preEvaluateExpression(x, entity)).collect(Collectors.toList()));
        }
        if (expression instanceof OrLogicExpression) {
            return new OrLogicExpression(((OrLogicExpression)expression).getChildren().stream().map(x -> LdapUtils.preEvaluateExpression(x, entity)).collect(Collectors.toList()));
        }
        if (expression instanceof NotLogicExpression) {
            return new NotLogicExpression(((NotLogicExpression)expression).getChildren().stream().map(x -> LdapUtils.preEvaluateExpression(x, entity)).collect(Collectors.toList()));
        }
        if (expression instanceof OperatorExpression) {
            OperatorExpression operator = (OperatorExpression)expression;
            switch (LdapUtils.normalizeAttribute(operator.getAttribute())) {
                case "2.5.4.0": {
                    return new BooleanValue(operator.check("organizationalUnit") || operator.check("top"));
                }
                case "2.5.4.11": {
                    return new BooleanValue(operator.check(entity.getId()));
                }
                case "2.5.4.13": {
                    return new BooleanValue(operator.check(entity.getDescription()));
                }
            }
            if (operator instanceof PresenceOperator) {
                return new BooleanValue(operator.isNegated());
            }
            return BooleanValue.falseValue();
        }
        return expression;
    }

    public static QueryExpression preEvaluateExpressionForGroup(QueryExpression expression) {
        if (expression instanceof AndLogicExpression) {
            return new AndLogicExpression(((AndLogicExpression)expression).getChildren().stream().map(LdapUtils::preEvaluateExpressionForGroup).collect(Collectors.toList()));
        }
        if (expression instanceof OrLogicExpression) {
            return new OrLogicExpression(((OrLogicExpression)expression).getChildren().stream().map(LdapUtils::preEvaluateExpressionForGroup).collect(Collectors.toList()));
        }
        if (expression instanceof NotLogicExpression) {
            return new NotLogicExpression(((NotLogicExpression)expression).getChildren().stream().map(LdapUtils::preEvaluateExpressionForGroup).collect(Collectors.toList()));
        }
        if (expression instanceof OperatorExpression) {
            OperatorExpression operator = (OperatorExpression)expression;
            switch (LdapUtils.normalizeAttribute(operator.getAttribute())) {
                case "2.5.4.0": {
                    return new BooleanValue(operator.check("groupOfNames") || operator.check("groupOfUniqueNames") || operator.check("top"));
                }
                case "2.5.4.11": {
                    return new BooleanValue(operator.check(OU_GROUPS));
                }
                case "2.5.4.3": 
                case "2.5.4.13": {
                    if (operator instanceof PresenceOperator) {
                        return new BooleanValue(!operator.isNegated());
                    }
                    return operator;
                }
                case "2.5.4.31": 
                case "2.5.4.50": 
                case "1.2.840.113556.1.2.102": {
                    return operator;
                }
            }
            if (operator instanceof PresenceOperator) {
                return new BooleanValue(operator.isNegated());
            }
            return BooleanValue.falseValue();
        }
        return expression;
    }

    public static QueryExpression preEvaluateExpressionForUser(QueryExpression expression) {
        if (expression instanceof AndLogicExpression) {
            return new AndLogicExpression(((AndLogicExpression)expression).getChildren().stream().map(LdapUtils::preEvaluateExpressionForUser).collect(Collectors.toList()));
        }
        if (expression instanceof OrLogicExpression) {
            return new OrLogicExpression(((OrLogicExpression)expression).getChildren().stream().map(LdapUtils::preEvaluateExpressionForUser).collect(Collectors.toList()));
        }
        if (expression instanceof NotLogicExpression) {
            return new NotLogicExpression(((NotLogicExpression)expression).getChildren().stream().map(LdapUtils::preEvaluateExpressionForUser).collect(Collectors.toList()));
        }
        if (expression instanceof OperatorExpression) {
            OperatorExpression operator = (OperatorExpression)expression;
            switch (LdapUtils.normalizeAttribute(operator.getAttribute())) {
                case "2.5.4.0": {
                    return new BooleanValue(operator.check("inetOrgPerson") || operator.check("organizationalPerson") || operator.check("person") || operator.check("top"));
                }
                case "2.5.4.11": {
                    return new BooleanValue(operator.check(OU_USERS));
                }
                case "0.9.2342.19200300.100.1.1": 
                case "2.5.4.3": 
                case "2.5.4.4": 
                case "2.5.4.42": 
                case "2.16.840.1.113730.3.1.241": 
                case "0.9.2342.19200300.100.1.3": {
                    if (operator instanceof PresenceOperator) {
                        return new BooleanValue(!operator.isNegated());
                    }
                    return operator;
                }
                case "1.2.840.113556.1.2.102": {
                    return operator;
                }
            }
            if (operator instanceof PresenceOperator) {
                return new BooleanValue(operator.isNegated());
            }
            return BooleanValue.falseValue();
        }
        return expression;
    }

    public static boolean evaluateExpression(QueryExpression expression) {
        if (expression instanceof AndLogicExpression) {
            return ((AndLogicExpression)expression).getChildren().stream().allMatch(LdapUtils::evaluateExpression);
        }
        if (expression instanceof OrLogicExpression) {
            return ((OrLogicExpression)expression).getChildren().stream().anyMatch(LdapUtils::evaluateExpression);
        }
        if (expression instanceof NotLogicExpression) {
            return ((NotLogicExpression)expression).getChildren().stream().noneMatch(LdapUtils::evaluateExpression);
        }
        if (expression instanceof BooleanValue) {
            return ((BooleanValue)expression).getValue();
        }
        throw new IllegalArgumentException("Expression is not ready with element " + expression.getClass().getSimpleName());
    }

    public static Set<String> getAttributes(FilteringOperationContext context) {
        return Arrays.stream(context.getReturningAttributesString()).map(LdapUtils::normalizeAttribute).collect(Collectors.toSet());
    }

    public static String normalizeAttribute(String attribute) {
        if (attribute.equalsIgnoreCase("dc") || attribute.equalsIgnoreCase("domainComponent") || attribute.equals("0.9.2342.19200300.100.1.25")) {
            return "dc";
        }
        if (attribute.equals("2.5.4.0") || attribute.equalsIgnoreCase("objectClass")) {
            return "2.5.4.0";
        }
        if (attribute.equals("2.5.4.11") || attribute.equalsIgnoreCase("ou") || attribute.equalsIgnoreCase("organizationalUnitName")) {
            return "2.5.4.11";
        }
        if (attribute.equals("0.9.2342.19200300.100.1.1") || attribute.equalsIgnoreCase("uid") || attribute.equalsIgnoreCase("userid")) {
            return "0.9.2342.19200300.100.1.1";
        }
        if (attribute.equals("2.5.4.3") || attribute.equalsIgnoreCase("cn") || attribute.equalsIgnoreCase("commonName")) {
            return "2.5.4.3";
        }
        if (attribute.equals("2.5.4.4") || attribute.equalsIgnoreCase("sn") || attribute.equalsIgnoreCase("surname")) {
            return "2.5.4.4";
        }
        if (attribute.equals("2.5.4.42") || attribute.equalsIgnoreCase("gn") || attribute.equalsIgnoreCase("givenName")) {
            return "2.5.4.42";
        }
        if (attribute.equals("2.16.840.1.113730.3.1.241") || attribute.equalsIgnoreCase("displayName")) {
            return "2.16.840.1.113730.3.1.241";
        }
        if (attribute.equals("0.9.2342.19200300.100.1.3") || attribute.equalsIgnoreCase("mail")) {
            return "0.9.2342.19200300.100.1.3";
        }
        if (attribute.equals("2.5.4.13") || attribute.equalsIgnoreCase("description")) {
            return "2.5.4.13";
        }
        if (attribute.equals("2.5.4.31") || attribute.equalsIgnoreCase("member")) {
            return "2.5.4.31";
        }
        if (attribute.equals("2.5.4.50") || attribute.equalsIgnoreCase("uniqueMember")) {
            return "2.5.4.50";
        }
        if (attribute.equals(MEMBER_OF_AT_OID) || attribute.equalsIgnoreCase(MEMBER_OF_AT)) {
            return MEMBER_OF_AT_OID;
        }
        return attribute;
    }
}

