/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.api.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import technology.openpool.ldap.adapter.api.cursor.ClosableIterator;
import technology.openpool.ldap.adapter.api.cursor.Cursor;

public abstract class MappableCursor<T>
implements Cursor<T> {
    @Override
    public abstract boolean next();

    @Override
    public abstract T get();

    public <R> MappableCursor<R> map(final Function<T, R> f) {
        return new MappableCursor<R>(){

            @Override
            public boolean next() {
                return MappableCursor.this.next();
            }

            @Override
            public R get() {
                return f.apply(MappableCursor.this.get());
            }

            @Override
            public void close() throws IOException {
                MappableCursor.this.close();
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(Function.identity());
    }

    public <R> ClosableIterator<R> iterator(final Function<T, R> f) {
        return new ClosableIterator<R>(){
            private boolean initialized = false;
            private boolean hasMore;

            @Override
            public boolean hasNext() {
                if (!this.initialized) {
                    this.hasMore = MappableCursor.this.next();
                    this.initialized = true;
                }
                return this.hasMore;
            }

            @Override
            public R next() {
                if (!this.initialized) {
                    this.hasMore = MappableCursor.this.next();
                }
                if (!this.hasMore) {
                    throw new NoSuchElementException("There is no element left for further iterations.");
                }
                this.initialized = false;
                return f.apply(MappableCursor.this.get());
            }

            @Override
            public void close() throws IOException {
                MappableCursor.this.close();
            }
        };
    }

    @Override
    public void close() throws IOException {
    }

    public static <T> MappableCursor<T> fromIterable(Iterable<T> iterable) {
        return MappableCursor.fromIterator(iterable.iterator());
    }

    public static <T> MappableCursor<T> fromIterator(final Iterator<T> iterator) {
        return new MappableCursor<T>(){
            private T element;

            @Override
            public boolean next() {
                this.element = iterator.hasNext() ? iterator.next() : null;
                return this.element != null;
            }

            @Override
            public T get() {
                if (this.element == null) {
                    throw new NoSuchElementException("There is no element for iterations.");
                }
                return this.element;
            }

            @Override
            public void close() throws IOException {
                if (iterator instanceof ClosableIterator) {
                    ((ClosableIterator)iterator).close();
                }
            }
        };
    }

    public static <T, C extends Cursor<T>> MappableCursor<T> flatten(C ... cursors) {
        return MappableCursor.flatten(Arrays.asList(cursors));
    }

    public static <T, C extends Cursor<T>> MappableCursor<T> flatten(Collection<C> cursors) {
        final ArrayList<C> cursorList = new ArrayList<C>(cursors);
        return new MappableCursor<T>(){
            int index = 0;

            @Override
            public boolean next() {
                while (this.index < cursorList.size()) {
                    if (((Cursor)cursorList.get(this.index)).next()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public T get() {
                return ((Cursor)cursorList.get(this.index)).get();
            }

            @Override
            public void close() throws IOException {
                for (Cursor cursor : cursorList) {
                    cursor.close();
                }
            }
        };
    }
}

