/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.api.cursor.apacheds;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorClosedException;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import technology.openpool.ldap.adapter.api.cursor.Cursor;
import technology.openpool.ldap.adapter.api.exception.InternalServerException;

public class IterableEntryCursor
extends AbstractCursor<Entry> {
    private final Logger logger;
    private final Cursor<Entry> entries;
    private boolean closed = false;

    public IterableEntryCursor(Logger logger, Cursor<Entry> entries) {
        this.logger = logger;
        this.entries = entries;
    }

    public void before(Entry entry) throws LdapException, CursorException {
    }

    public void after(Entry entry) throws LdapException, CursorException {
    }

    public void beforeFirst() throws LdapException, CursorException {
    }

    public void afterLast() throws LdapException, CursorException {
    }

    public boolean first() throws LdapException, CursorException {
        return true;
    }

    public boolean last() throws LdapException, CursorException {
        return false;
    }

    public boolean previous() throws LdapException, CursorException {
        return false;
    }

    public boolean available() {
        return true;
    }

    public void close(Exception cause) throws IOException {
        super.close(cause);
        this.entries.close();
        this.logger.warn("An entry cursor was closed with an exception.", (Throwable)cause);
        this.logger.debug("[Thread ID {}] - An entry cursor is closed.", (Object)Thread.currentThread().getId());
    }

    public void close() throws IOException {
        super.close();
        this.entries.close();
        this.logger.debug("[Thread ID {}] - An entry cursor was closed.", (Object)Thread.currentThread().getId());
    }

    public boolean next() {
        try {
            if (this.closed) {
                throw new CursorClosedException("Cannot perform next method on closed cursor.");
            }
            return this.entries.next();
        }
        catch (Exception e) {
            this.logger.error("Caught an exception while accessing a cursor.", (Throwable)e);
            throw new InternalServerException("A cursor has detected an internal server error.");
        }
    }

    public Entry get() {
        try {
            if (this.closed) {
                throw new CursorClosedException("Cannot perform get method on closed cursor.");
            }
            return this.entries.get();
        }
        catch (CursorClosedException e) {
            this.logger.error("Caught an exception while accessing a cursor.", (Throwable)e);
            throw new InternalServerException("A cursor has detected an internal server error.");
        }
    }
}

