/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.api.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import technology.openpool.ldap.adapter.api.database.exception.UnknownColumnException;
import technology.openpool.ldap.adapter.api.entity.Entity;
import technology.openpool.ldap.adapter.api.entity.EntityType;

public class MembershipEntity
extends Entity {
    private final Set<String> memberGroupIds;
    private final Set<String> memberUserIds;

    public MembershipEntity(String parentGroupId, Set<String> memberGroupIds, Set<String> memberUserIds) {
        super(parentGroupId.toLowerCase());
        this.memberGroupIds = memberGroupIds.stream().map(String::toLowerCase).collect(Collectors.toSet());
        this.memberUserIds = memberUserIds.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    public String getParentGroupId() {
        return this.getId();
    }

    public Set<String> getMemberGroupIds() {
        return new HashSet<String>(this.memberGroupIds);
    }

    public Set<String> getMemberUserIds() {
        return new HashSet<String>(this.memberUserIds);
    }

    @Override
    public EntityType getEntityType() {
        return null;
    }

    @Override
    protected Object findColumn(String columnName) {
        throw new UnknownColumnException("The membership entity has no columns.");
    }
}

