/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.api.entity;

import technology.openpool.ldap.adapter.api.database.exception.UnknownColumnException;
import technology.openpool.ldap.adapter.api.entity.Entity;
import technology.openpool.ldap.adapter.api.entity.EntityType;

public class UserEntity
extends Entity {
    private final String username;
    private final String lastName;
    private final String firstName;
    private final String displayName;
    private final String email;
    private final boolean active;

    public UserEntity(String username, String lastName, String firstName, String displayName, String email, boolean active) {
        super(username.toLowerCase());
        this.username = username;
        this.lastName = lastName;
        this.firstName = firstName;
        this.displayName = displayName;
        this.email = email;
        this.active = active;
    }

    public String getUsername() {
        return this.username;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.USER;
    }

    @Override
    protected Object findColumn(String columnName) {
        switch (columnName) {
            case "type": {
                return this.getEntityType().toString();
            }
            case "id": {
                return this.getId();
            }
            case "username": {
                return this.getUsername();
            }
            case "last_name": {
                return this.getLastName();
            }
            case "first_name": {
                return this.getFirstName();
            }
            case "display_name": {
                return this.getDisplayName();
            }
            case "email": {
                return this.getEmail();
            }
            case "active": {
                return this.isActive();
            }
        }
        throw new UnknownColumnException("Cannot find column " + columnName + " for user entity.");
    }
}

