/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.api.query;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import technology.openpool.ldap.adapter.api.query.BinaryOperator;

public final class WildcardOperator
extends BinaryOperator<WildcardOperator> {
    private final Pattern pattern;
    private final String initialSegment;
    private final String finalSegment;
    private final List<String> middleSegments;

    public WildcardOperator(String attribute, Pattern pattern, String initialSegment, String finalSegment, List<String> middleSegments, boolean negated, boolean ignoreCase) {
        super(attribute, negated, ignoreCase);
        this.pattern = pattern;
        this.initialSegment = initialSegment;
        this.finalSegment = finalSegment;
        this.middleSegments = new ArrayList<String>(middleSegments);
    }

    public WildcardOperator(String attribute, Pattern pattern, String initialSegment, String finalSegment, List<String> middleSegments) {
        this(attribute, pattern, initialSegment, finalSegment, middleSegments, false, true);
    }

    @Override
    public String getValue() {
        return this.pattern.pattern();
    }

    public String getValue(Format format) {
        if (format == Format.REGEX) {
            return this.pattern.pattern();
        }
        if (format == Format.LDAP) {
            StringBuilder builder = new StringBuilder();
            if (this.initialSegment == null) {
                builder.append('*');
            } else {
                builder.append(this.initialSegment.replace("*", "\\2A")).append('*');
            }
            for (String middleSegment : this.middleSegments) {
                builder.append(middleSegment.replace("*", "\\2A"));
                builder.append('*');
            }
            if (this.finalSegment != null) {
                builder.append(this.finalSegment.replace("*", "\\2A"));
            }
            return builder.toString();
        }
        if (format == Format.SQL) {
            StringBuilder builder = new StringBuilder();
            if (this.initialSegment == null) {
                builder.append('%');
            } else {
                builder.append(this.initialSegment.replace("%", "\\%")).append('%');
            }
            for (String middleSegment : this.middleSegments) {
                builder.append(middleSegment.replace("%", "\\%"));
                builder.append('%');
            }
            if (this.finalSegment != null) {
                builder.append(this.finalSegment.replace("%", "\\%"));
            }
            return builder.toString();
        }
        throw new IllegalArgumentException("Cannot handle unexpected format for wildcard pattern.");
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public WildcardOperator negate() {
        return new WildcardOperator(this.getAttribute(), this.pattern, this.initialSegment, this.finalSegment, this.middleSegments, !this.isNegated(), this.isIgnoreCase());
    }

    @Override
    public boolean check(String value) {
        if (this.isIgnoreCase()) {
            return this.pattern.matcher(value.toLowerCase()).matches();
        }
        return this.pattern.matcher(value).matches();
    }

    public static enum Format {
        REGEX,
        LDAP,
        SQL;

    }
}

