/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.backend;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technology.openpool.ldap.adapter.ServerConfiguration;
import technology.openpool.ldap.adapter.api.LdapUtils;
import technology.openpool.ldap.adapter.api.cursor.MappableCursor;
import technology.openpool.ldap.adapter.api.database.Row;
import technology.openpool.ldap.adapter.api.directory.NestedDirectoryBackend;
import technology.openpool.ldap.adapter.api.directory.exception.DirectoryAccessFailureException;
import technology.openpool.ldap.adapter.api.directory.exception.EntityNotFoundException;
import technology.openpool.ldap.adapter.api.directory.exception.SecurityProblemException;
import technology.openpool.ldap.adapter.api.entity.EntityType;
import technology.openpool.ldap.adapter.api.entity.GroupEntity;
import technology.openpool.ldap.adapter.api.entity.MembershipEntity;
import technology.openpool.ldap.adapter.api.entity.UserEntity;
import technology.openpool.ldap.adapter.api.query.AndLogicExpression;
import technology.openpool.ldap.adapter.api.query.EqualOperator;
import technology.openpool.ldap.adapter.api.query.OrLogicExpression;
import technology.openpool.ldap.adapter.api.query.QueryExpression;

public class CrowdDirectoryBackend
implements NestedDirectoryBackend {
    public static final String CONFIG_READINESS_CHECK = "readiness-check";
    private final Logger logger = LoggerFactory.getLogger(CrowdDirectoryBackend.class);
    private final CrowdClient crowdClient;
    private final boolean useReadinessCheck;

    public CrowdDirectoryBackend(ServerConfiguration config) {
        Properties properties = config.getBackendProperties();
        this.useReadinessCheck = Boolean.parseBoolean(properties.getProperty(CONFIG_READINESS_CHECK, "true"));
        ClientPropertiesImpl props = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        this.crowdClient = new RestCrowdClientFactory().newInstance((ClientProperties)props);
    }

    @Override
    public String getId() {
        return "crowd";
    }

    @Override
    public void startup() {
        try {
            if (this.useReadinessCheck) {
                this.crowdClient.testConnection();
            }
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public void shutdown() {
        this.crowdClient.shutdown();
    }

    @Override
    public MappableCursor<Row> runQueryExpression(String txId, SchemaManager schemaManager, QueryExpression expression, EntityType entityType) {
        throw new UnsupportedOperationException("Query generation not supported for Crowd directory backend.");
    }

    @Override
    public GroupEntity getGroup(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getGroup; ID={}", (Object)id);
        try {
            return this.createGroupEntity(this.crowdClient.getGroup(id));
        }
        catch (GroupNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public UserEntity getUser(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getUser; ID={}", (Object)id);
        try {
            UserEntity entity = this.createUserEntity(this.crowdClient.getUser(id));
            return entity;
        }
        catch (UserNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public UserEntity getAuthenticatedUser(String id, String password) throws EntityNotFoundException {
        this.logger.info("Backend call: getAuthenticatedUser; ID={}", (Object)id);
        try {
            return this.createUserEntity(this.crowdClient.authenticateUser(id, password));
        }
        catch (UserNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | ExpiredCredentialException | InactiveAccountException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<GroupEntity> getAllGroups() {
        return this.getAllGroups(0, Integer.MAX_VALUE);
    }

    @Override
    public Set<GroupEntity> getAllGroups(int startIndex, int maxResults) {
        this.logger.info("Backend call: getGroups({}, {})", (Object)startIndex, (Object)maxResults);
        try {
            return this.crowdClient.searchGroups((SearchRestriction)NullRestrictionImpl.INSTANCE, startIndex, maxResults).stream().map(this::createGroupEntity).collect(Collectors.toSet());
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<UserEntity> getAllUsers() {
        return this.getAllUsers(0, Integer.MAX_VALUE);
    }

    @Override
    public Set<UserEntity> getAllUsers(int startIndex, int maxResults) {
        this.logger.info("Backend call: getUsers({}, {})", (Object)startIndex, (Object)maxResults);
        try {
            return this.crowdClient.searchUsers((SearchRestriction)NullRestrictionImpl.INSTANCE, startIndex, maxResults).stream().map(this::createUserEntity).collect(Collectors.toSet());
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<UserEntity> getDirectUsersOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getDirectUsersOfGroup; ID={}", (Object)id);
        try {
            return this.crowdClient.getUsersOfGroup(id, 0, Integer.MAX_VALUE).stream().map(this::createUserEntity).collect(Collectors.toSet());
        }
        catch (GroupNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<GroupEntity> getDirectGroupsOfUser(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getDirectGroupsOfUser; ID={}", (Object)id);
        try {
            return this.crowdClient.getGroupsForUser(id, 0, Integer.MAX_VALUE).stream().map(this::createGroupEntity).collect(Collectors.toSet());
        }
        catch (UserNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<UserEntity> getTransitiveUsersOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getTransitiveUsersOfGroup; ID={}", (Object)id);
        try {
            return this.crowdClient.getNestedUsersOfGroup(id, 0, Integer.MAX_VALUE).stream().map(this::createUserEntity).collect(Collectors.toSet());
        }
        catch (GroupNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<GroupEntity> getTransitiveGroupsOfUser(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getTransitiveGroupsOfUser; ID={}", (Object)id);
        try {
            return this.crowdClient.getGroupsForNestedUser(id, 0, Integer.MAX_VALUE).stream().map(this::createGroupEntity).collect(Collectors.toSet());
        }
        catch (UserNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<GroupEntity> getDirectChildGroupsOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getDirectChildGroupsOfGroup; ID={}", (Object)id);
        try {
            return this.crowdClient.getChildGroupsOfGroup(id, 0, Integer.MAX_VALUE).stream().map(this::createGroupEntity).collect(Collectors.toSet());
        }
        catch (GroupNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<GroupEntity> getDirectParentGroupsOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getDirectParentGroupsOfGroup; ID={}", (Object)id);
        try {
            return this.crowdClient.getParentGroupsForGroup(id, 0, Integer.MAX_VALUE).stream().map(this::createGroupEntity).collect(Collectors.toSet());
        }
        catch (GroupNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<GroupEntity> getTransitiveChildGroupsOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getTransitiveChildGroupsOfGroup; ID={}", (Object)id);
        try {
            return this.crowdClient.getNestedChildGroupsOfGroup(id, 0, Integer.MAX_VALUE).stream().map(this::createGroupEntity).collect(Collectors.toSet());
        }
        catch (GroupNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public Set<GroupEntity> getTransitiveParentGroupsOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Backend call: getTransitiveParentGroupsOfGroup; ID={}", (Object)id);
        try {
            return this.crowdClient.getParentGroupsForNestedGroup(id, 0, Integer.MAX_VALUE).stream().map(this::createGroupEntity).collect(Collectors.toSet());
        }
        catch (GroupNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    @Override
    public MappableCursor<MembershipEntity> getMemberships() {
        this.logger.info("Backend call: getMemberships");
        try {
            return MappableCursor.fromIterable(this.crowdClient.getMemberships()).map(membership -> new MembershipEntity(membership.getGroupName(), membership.getChildGroupNames(), membership.getUserNames()));
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException e) {
            throw new SecurityProblemException(e);
        }
        catch (OperationFailedException e) {
            throw new DirectoryAccessFailureException(e);
        }
    }

    private GroupEntity createGroupEntity(Group group) {
        return new GroupEntity(group.getName(), group.getDescription());
    }

    private UserEntity createUserEntity(User user) {
        return new UserEntity(user.getName(), user.getLastName(), user.getFirstName(), user.getDisplayName(), user.getEmailAddress(), user.isActive());
    }

    private SearchRestriction createGroupSearchRestriction(QueryExpression expression) {
        if (expression instanceof AndLogicExpression) {
            return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, (Collection)((AndLogicExpression)expression).getChildren().stream().map(this::createGroupSearchRestriction).collect(Collectors.toList()));
        }
        if (expression instanceof OrLogicExpression) {
            return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, (Collection)((OrLogicExpression)expression).getChildren().stream().map(this::createGroupSearchRestriction).collect(Collectors.toList()));
        }
        if (expression instanceof EqualOperator) {
            switch (LdapUtils.normalizeAttribute(((EqualOperator)expression).getAttribute())) {
                case "2.5.4.3": {
                    return new TermRestriction(GroupTermKeys.NAME, MatchMode.EXACTLY_MATCHES, (Object)((EqualOperator)expression).getValue());
                }
                case "2.5.4.13": {
                    return new TermRestriction(GroupTermKeys.DESCRIPTION, MatchMode.EXACTLY_MATCHES, (Object)((EqualOperator)expression).getValue());
                }
            }
        }
        return NullRestrictionImpl.INSTANCE;
    }
}

