/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.backend;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technology.openpool.ldap.adapter.ServerConfiguration;
import technology.openpool.ldap.adapter.api.directory.NestedDirectoryBackend;
import technology.openpool.ldap.adapter.backend.ProxyDirectoryBackend;

public class LockingDirectoryBackend
extends ProxyDirectoryBackend {
    private final Logger logger = LoggerFactory.getLogger(LockingDirectoryBackend.class);
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public LockingDirectoryBackend(ServerConfiguration config, NestedDirectoryBackend directoryBackend) {
        super(config, directoryBackend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withReadAccess(Supplier<T> block) {
        T result;
        long start = System.currentTimeMillis();
        this.rwLock.readLock().lock();
        try {
            result = super.withReadAccess(block);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        long end = System.currentTimeMillis();
        this.logger.debug("[Thread ID {}] - A read only session was performed in {} ms.", (Object)Thread.currentThread().getId(), (Object)(end - start == 0L ? 1L : end - start));
        return result;
    }

    @Override
    public void withReadAccess(Runnable block) {
        this.withReadAccess(() -> {
            block.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withWriteAccess(Supplier<T> block) {
        T result;
        long start = System.currentTimeMillis();
        this.rwLock.writeLock().lock();
        try {
            result = super.withWriteAccess(block);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        long end = System.currentTimeMillis();
        this.logger.debug("[Thread ID {}] - A writing session was performed in {} ms.", (Object)Thread.currentThread().getId(), (Object)(end - start == 0L ? 1L : end - start));
        return result;
    }

    @Override
    public void withWriteAccess(Runnable block) {
        this.withWriteAccess(() -> {
            block.run();
            return null;
        });
    }
}

