/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.backend;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technology.openpool.ldap.adapter.ServerConfiguration;
import technology.openpool.ldap.adapter.api.cursor.MappableCursor;
import technology.openpool.ldap.adapter.api.directory.NestedDirectoryBackend;
import technology.openpool.ldap.adapter.api.entity.MembershipEntity;
import technology.openpool.ldap.adapter.backend.ProxyDirectoryBackend;

public class MirroredCrowdDirectoryBackend
extends ProxyDirectoryBackend {
    public static final String CONFIG_APP_NAME = "application.name";
    public static final String CONFIG_REST_USERNAME = "rest.username";
    public static final String CONFIG_REST_USER_PW = "rest.user-password";
    public static final String CONFIG_REST_BASE_URL = "rest.base-url";
    public static final String CONFIG_SYNC_PAGE_SIZE = "mirror.sync.page-size";
    public static final String CONFIG_AUDIT_LOG_PAGE_SIZE = "mirror.audit-log.page-size";
    public static final String CONFIG_AUDIT_LOG_PAGE_LIMIT = "mirror.audit-log.page-limit";
    public static final String CONFIG_SYNC_INITIAL_DELAY = "mirror.sync.initialdelay";
    public static final String CONFIG_SYNC_PERIOD = "mirror.sync.period";
    public static final String CONFIG_SYNC_USEDBLOCK = "mirror.sync.usebdlock";
    public static final String CONFIG_SYNC_LOCKID = "mirror.sync.lockid";
    public static final String CONFIG_FORCE_FULL_SYNC_ON_BOOT = "mirror.force-full-sync-on-boot";
    private final Logger logger = LoggerFactory.getLogger(MirroredCrowdDirectoryBackend.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final MirrorStrategy mirrorStrategy;
    private final AuditLogProcessor auditLogProcessor;

    public MirroredCrowdDirectoryBackend(ServerConfiguration config, NestedDirectoryBackend directoryBackend) {
        super(config, directoryBackend);
        Properties properties = config.getBackendProperties();
        String appName = properties.getProperty(CONFIG_APP_NAME);
        String restUsername = properties.getProperty(CONFIG_REST_USERNAME);
        String restUserPassword = properties.getProperty(CONFIG_REST_USER_PW);
        String restBaseUrl = properties.getProperty(CONFIG_REST_BASE_URL);
        String syncPageSizeValue = properties.getProperty(CONFIG_SYNC_PAGE_SIZE);
        String auditLogPageSizeValue = properties.getProperty(CONFIG_AUDIT_LOG_PAGE_SIZE);
        String auditLogPageLimitValue = properties.getProperty(CONFIG_AUDIT_LOG_PAGE_LIMIT);
        String syncInitialDelayValue = properties.getProperty(CONFIG_SYNC_INITIAL_DELAY);
        String syncPeriodValue = properties.getProperty(CONFIG_SYNC_PERIOD);
        String syncUseDblockValue = properties.getProperty(CONFIG_SYNC_USEDBLOCK);
        String syncLockIdValue = properties.getProperty(CONFIG_SYNC_LOCKID);
        String forceFullSyncOnBootValue = properties.getProperty(CONFIG_FORCE_FULL_SYNC_ON_BOOT);
        if (appName == null) {
            throw new IllegalArgumentException("Missing value for application.name");
        }
        if (restUsername == null) {
            throw new IllegalArgumentException("Missing value for rest.username");
        }
        if (restUserPassword == null) {
            throw new IllegalArgumentException("Missing value for rest.user-password");
        }
        if (restBaseUrl == null) {
            throw new IllegalArgumentException("Missing value for rest.base-url");
        }
        if (syncPageSizeValue == null) {
            throw new IllegalArgumentException("Missing value for mirror.sync.page-size");
        }
        if (auditLogPageSizeValue == null) {
            throw new IllegalArgumentException("Missing value for mirror.audit-log.page-size");
        }
        if (auditLogPageLimitValue == null) {
            throw new IllegalArgumentException("Missing value for mirror.audit-log.page-limit");
        }
        if (syncInitialDelayValue == null) {
            throw new IllegalArgumentException("Missing value for mirror.sync.initialdelay");
        }
        if (syncPeriodValue == null) {
            throw new IllegalArgumentException("Missing value for mirror.sync.period");
        }
        if (syncUseDblockValue == null) {
            throw new IllegalArgumentException("Missing value for mirror.sync.usebdlock");
        }
        if (syncLockIdValue == null) {
            throw new IllegalArgumentException("Missing value for mirror.sync.lockid");
        }
        if (forceFullSyncOnBootValue == null) {
            throw new IllegalArgumentException("Missing value for mirror.force-full-sync-on-boot");
        }
        int syncPageSize = Integer.parseInt(syncPageSizeValue);
        int auditLogPageSize = Integer.parseInt(auditLogPageSizeValue);
        int auditLogPageLimit = Integer.parseInt(auditLogPageLimitValue);
        int syncInitialDelay = Integer.parseInt(syncInitialDelayValue);
        int syncPeriod = Integer.parseInt(syncPeriodValue);
        boolean syncUseDblock = Boolean.parseBoolean(syncUseDblockValue);
        int syncLockId = Integer.parseInt(syncLockIdValue);
        boolean forceFullSyncOnBoot = Boolean.parseBoolean(forceFullSyncOnBootValue);
        if (syncPageSize < 1) {
            throw new IllegalArgumentException("The page size cannot be less than one.");
        }
        if (auditLogPageSize < 1) {
            throw new IllegalArgumentException("The page limit cannot be less than one.");
        }
        if (auditLogPageLimit < 1) {
            throw new IllegalArgumentException("The page limit cannot be less than one.");
        }
        this.auditLogProcessor = new AuditLogProcessor(appName, restUsername, restUserPassword, restBaseUrl, auditLogPageLimit, auditLogPageSize);
        this.mirrorStrategy = new MirrorStrategy(syncPageSize, forceFullSyncOnBoot, syncInitialDelay, syncPeriod, syncUseDblock, syncLockId);
    }

    @Override
    public void startup() {
        super.startup();
        this.scheduler.scheduleAtFixedRate(this.mirrorStrategy, this.mirrorStrategy.syncInitialDelay, this.mirrorStrategy.syncPeriod, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Could not complete all synchronization tasks.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        super.shutdown();
    }

    @Override
    public <T> T withReadAccess(Supplier<T> block) {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return super.withReadAccess(block);
    }

    @Override
    public void withReadAccess(Runnable block) {
        this.withReadAccess(() -> {
            block.run();
            return null;
        });
    }

    @Override
    public <T> T withWriteAccess(Supplier<T> block) {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return super.withWriteAccess(block);
    }

    @Override
    public void withWriteAccess(Runnable block) {
        this.withWriteAccess(() -> {
            block.run();
            return null;
        });
    }

    private class AuditLogProcessor {
        private final Random random = new Random();
        private final String appName;
        private final String restUsername;
        private final String restUserPassword;
        private final String restBaseUrl;
        private final int pageLimit;
        private final int pageSize;

        public AuditLogProcessor(String appName, String restUsername, String restUserPassword, String restBaseUrl, int pageLimit, int pageSize) {
            this.appName = appName;
            this.restUsername = restUsername;
            this.restUserPassword = restUserPassword;
            this.restBaseUrl = restBaseUrl;
            this.pageLimit = pageLimit;
            this.pageSize = pageSize;
        }

        public AuditLogState updateConcurrent(Supplier<Boolean> supplier) {
            boolean requireRetry = true;
            boolean aborted = false;
            while (requireRetry && !aborted) {
                requireRetry = false;
                this.setSynchronizationMarker(AuditLogEntry.SYNC_START);
                aborted = supplier.get();
                if (aborted) continue;
                this.setSynchronizationMarker(AuditLogEntry.SYNC_STOP);
                AuditLogState state = this.getAuditLogState(false);
                if (state.equals((Object)AuditLogState.CON_ISSUE)) {
                    return AuditLogState.CON_ISSUE;
                }
                if (state.equals((Object)AuditLogState.UP_TO_DATE)) {
                    this.setSynchronizationMarker(AuditLogEntry.SYNC_COMPLETE);
                    continue;
                }
                MirroredCrowdDirectoryBackend.this.logger.info("Retry synchronization.");
                requireRetry = true;
                this.waitBackoff(1000, 3000);
            }
            if (aborted) {
                return AuditLogState.UNDEFINED;
            }
            return AuditLogState.UP_TO_DATE;
        }

        public AuditLogState getAuditLogState(boolean expectCommitted) {
            return this.repeatableRead(() -> {
                boolean committed = !expectCommitted;
                boolean changesFound = false;
                boolean startedMarkerFound = false;
                boolean finishedMarkerFound = false;
                boolean lastPageDone = false;
                int page = 0;
                while (!lastPageDone && page < this.pageLimit) {
                    JsonObject result;
                    try {
                        result = MirroredCrowdDirectoryBackend.this.auditLogProcessor.queryAuditLog(page, this.pageSize);
                        ++page;
                    }
                    catch (IOException e) {
                        MirroredCrowdDirectoryBackend.this.logger.error("Cannot call REST endpoint to query audit log for pagination.", (Throwable)e);
                        return AuditLogState.CON_ISSUE;
                    }
                    lastPageDone = result.getAsJsonObject().get("isLastPage").getAsBoolean();
                    for (JsonElement valueElement : result.getAsJsonArray("values")) {
                        SyncState syncState = this.getSynchronizationState(valueElement);
                        if (syncState == SyncState.SYNC_COMPLETE) {
                            committed = true;
                            continue;
                        }
                        if (syncState == SyncState.NO_SYNC) {
                            changesFound = true;
                            startedMarkerFound = false;
                            finishedMarkerFound = false;
                            continue;
                        }
                        if (syncState == SyncState.FOREIGN_SYNC || !committed) continue;
                        if (syncState == SyncState.SYNC_START) {
                            startedMarkerFound = true;
                        } else if (syncState == SyncState.SYNC_STOP) {
                            startedMarkerFound = false;
                            finishedMarkerFound = true;
                        }
                        if (!startedMarkerFound || !finishedMarkerFound) continue;
                        if (changesFound) {
                            return AuditLogState.DELTA_UPDATE_REQUIRED;
                        }
                        return AuditLogState.UP_TO_DATE;
                    }
                }
                return AuditLogState.UNDEFINED;
            });
        }

        public SyncState getSynchronizationState(JsonElement valueElement) {
            String eventType = valueElement.getAsJsonObject().get("eventType").getAsString();
            if (eventType.matches("(SYNCHRONIZATION_(STARTED|FINISHED))|(COMPLETED)")) {
                JsonArray entities = valueElement.getAsJsonObject().getAsJsonArray("entities");
                if (entities.size() != 1) {
                    return SyncState.FOREIGN_SYNC;
                }
                JsonObject author = valueElement.getAsJsonObject().getAsJsonObject("author");
                JsonObject entity = entities.get(0).getAsJsonObject();
                if (!author.get("name").getAsString().equals(this.appName)) {
                    return SyncState.FOREIGN_SYNC;
                }
                if (!author.get("type").getAsString().equals("APPLICATION")) {
                    return SyncState.FOREIGN_SYNC;
                }
                if (!entity.get("name").getAsString().equals("synchronization")) {
                    return SyncState.FOREIGN_SYNC;
                }
                if (!entity.get("type").getAsString().equals("APPLICATION")) {
                    return SyncState.FOREIGN_SYNC;
                }
                if (eventType.equals("SYNCHRONIZATION_STARTED")) {
                    return SyncState.SYNC_START;
                }
                if (eventType.equals("SYNCHRONIZATION_FINISHED")) {
                    return SyncState.SYNC_STOP;
                }
                if (eventType.equals("COMPLETED")) {
                    return SyncState.SYNC_COMPLETE;
                }
            }
            return SyncState.NO_SYNC;
        }

        private AuditLogState repeatableRead(Supplier<AuditLogState> supplier) {
            boolean requireRetry = true;
            try {
                Long auditLogId = this.getLastAuditLogId();
                if (auditLogId == null) {
                    return AuditLogState.FULL_UPDATE_REQUIRED;
                }
                while (requireRetry) {
                    requireRetry = false;
                    AuditLogState result = supplier.get();
                    if (!result.equals((Object)AuditLogState.UNDEFINED)) {
                        return result;
                    }
                    Long currentAuditLogId = this.getLastAuditLogId();
                    if (currentAuditLogId == null) {
                        return AuditLogState.FULL_UPDATE_REQUIRED;
                    }
                    if (!auditLogId.equals(currentAuditLogId)) {
                        auditLogId = currentAuditLogId;
                        requireRetry = true;
                    }
                    this.waitBackoff(1000, 2000);
                }
            }
            catch (IOException e) {
                MirroredCrowdDirectoryBackend.this.logger.error("Cannot call REST endpoint to query audit log for last entry.", (Throwable)e);
                return AuditLogState.CON_ISSUE;
            }
            return AuditLogState.FULL_UPDATE_REQUIRED;
        }

        private void waitBackoff(int minMillis, int maxMillis) {
            if (minMillis >= maxMillis) {
                throw new IllegalArgumentException("Expect maximum greater than minimum.");
            }
            if (minMillis <= 0) {
                throw new IllegalArgumentException("Expect minimum greater than zero.");
            }
            int duration = this.random.nextInt(maxMillis - minMillis + 1) + minMillis;
            MirroredCrowdDirectoryBackend.this.logger.debug("Waiting a backoff time of {} milliseconds.", (Object)duration);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                MirroredCrowdDirectoryBackend.this.logger.error("The backoff waiting time was interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }

        private void setSynchronizationMarker(AuditLogEntry entry) {
            JsonObject node = new JsonObject();
            JsonObject author = new JsonObject();
            if (entry == AuditLogEntry.SYNC_START) {
                node.add("eventType", (JsonElement)new JsonPrimitive("SYNCHRONIZATION_STARTED"));
                node.add("eventMessage", (JsonElement)new JsonPrimitive("Started synchronization with application"));
            } else if (entry == AuditLogEntry.SYNC_STOP) {
                node.add("eventType", (JsonElement)new JsonPrimitive("SYNCHRONIZATION_FINISHED"));
                node.add("eventMessage", (JsonElement)new JsonPrimitive("Finished synchronization with application"));
            } else if (entry == AuditLogEntry.SYNC_COMPLETE) {
                node.add("eventType", (JsonElement)new JsonPrimitive("COMPLETED"));
                node.add("eventMessage", (JsonElement)new JsonPrimitive("Committed last synchronization with application"));
            }
            node.add("entityType", (JsonElement)new JsonPrimitive("APPLICATION"));
            node.add("entityName", (JsonElement)new JsonPrimitive("synchronization"));
            node.add("author", (JsonElement)author);
            author.add("name", (JsonElement)new JsonPrimitive(this.appName));
            author.add("type", (JsonElement)new JsonPrimitive("APPLICATION"));
            String route = "/rest/admin/1.0/auditlog";
            try {
                this.postRestApi(route, node, false);
            }
            catch (IOException e) {
                MirroredCrowdDirectoryBackend.this.logger.error("Cannot call REST endpoint to query audit log.", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }

        private Long getLastAuditLogId() throws IOException {
            JsonObject node = new JsonObject();
            JsonArray actions = new JsonArray();
            node.add("actions", (JsonElement)actions);
            actions.add("USER_CREATED");
            actions.add("USER_UPDATED");
            actions.add("USER_DELETED");
            actions.add("GROUP_CREATED");
            actions.add("GROUP_UPDATED");
            actions.add("GROUP_DELETED");
            actions.add("ADDED_TO_GROUP");
            actions.add("REMOVED_FROM_GROUP");
            String queryString = "?start=0&limit=1";
            String route = "/rest/admin/1.0/auditlog/query" + queryString;
            JsonObject result = this.postRestApi(route, node, true).get();
            JsonArray array = result.getAsJsonArray("values");
            if (array.size() != 1) {
                return null;
            }
            return array.get(0).getAsJsonObject().get("id").getAsLong();
        }

        private JsonObject queryAuditLog(int page, int pageSize) throws IOException {
            JsonObject node = new JsonObject();
            JsonArray actions = new JsonArray();
            node.add("actions", (JsonElement)actions);
            actions.add("USER_CREATED");
            actions.add("USER_UPDATED");
            actions.add("USER_DELETED");
            actions.add("GROUP_CREATED");
            actions.add("GROUP_UPDATED");
            actions.add("GROUP_DELETED");
            actions.add("ADDED_TO_GROUP");
            actions.add("REMOVED_FROM_GROUP");
            actions.add("SYNCHRONIZATION_STARTED");
            actions.add("SYNCHRONIZATION_FINISHED");
            actions.add("COMPLETED");
            String queryString = "?start=" + page * pageSize + "&limit=" + pageSize;
            String route = "/rest/admin/1.0/auditlog/query" + queryString;
            return this.postRestApi(route, node, true).get();
        }

        public String resolveToAlias(String username) {
            JsonObject aliases;
            JsonObject applications;
            String appId = null;
            try {
                applications = this.getRestApi("/rest/appmanagement/1/application", true).get();
                aliases = this.getRestApi("/rest/appmanagement/1/aliases?user=" + username, true).get();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            for (JsonElement element : applications.getAsJsonObject().getAsJsonArray("applications")) {
                JsonObject entry = element.getAsJsonObject().getAsJsonObject("ApplicationEntity");
                String id = entry.get("id").getAsString();
                String name = entry.get("name").getAsString();
                if (!name.equals(this.appName)) continue;
                appId = id;
            }
            if (appId == null || !aliases.getAsJsonObject().has(appId)) {
                return username;
            }
            String alias = aliases.getAsJsonObject().get(appId).getAsString();
            MirroredCrowdDirectoryBackend.this.logger.debug("Resolve username {} to alias {}: ", (Object)username, (Object)alias);
            return alias;
        }

        private Optional<JsonObject> getRestApi(String route, boolean expectResult) throws IOException {
            CloseableHttpClient httpclient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
            Gson gson = new Gson();
            String credentials = new String(Base64.getEncoder().encode((this.restUsername + ":" + this.restUserPassword).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            HttpGet request = new HttpGet(this.restBaseUrl + route);
            request.setHeader("Authorization", "Basic " + credentials);
            request.setHeader("Accept", "application/json");
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);
            if (!expectResult) {
                return Optional.empty();
            }
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
            try {
                return Optional.of((JsonObject)gson.fromJson(result, JsonObject.class));
            }
            catch (JsonSyntaxException e) {
                MirroredCrowdDirectoryBackend.this.logger.error("Cannot parse JSON object. Status code: {}; Result:\n {}", (Object)response.getStatusLine().getStatusCode(), (Object)result);
                throw e;
            }
        }

        private Optional<JsonObject> postRestApi(String route, JsonObject node, boolean expectResult) throws IOException {
            CloseableHttpClient httpclient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
            Gson gson = new Gson();
            String credentials = new String(Base64.getEncoder().encode((this.restUsername + ":" + this.restUserPassword).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            HttpPost request = new HttpPost(this.restBaseUrl + route);
            request.setHeader("Authorization", "Basic " + credentials);
            request.setHeader("Accept", "application/json");
            if (node != null) {
                request.setEntity((HttpEntity)new StringEntity(gson.toJson((JsonElement)node), ContentType.APPLICATION_JSON));
            }
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);
            if (!expectResult) {
                return Optional.empty();
            }
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
            try {
                return Optional.of((JsonObject)gson.fromJson(result, JsonObject.class));
            }
            catch (JsonSyntaxException e) {
                MirroredCrowdDirectoryBackend.this.logger.error("Cannot parse JSON object. Status code: {}; Result:\n {}", (Object)response.getStatusLine().getStatusCode(), (Object)result);
                throw e;
            }
        }
    }

    private class MirrorStrategy
    implements Runnable {
        private final int pageSize;
        private boolean forceFullSync;
        private boolean resetToggle = false;
        private int syncInitialDelay;
        private int syncPeriod;
        private boolean syncUseDblock = false;
        private int syncLockId;

        public MirrorStrategy(int pageSize, boolean forceFullSync, int syncInitialDelay, int syncPeriod, boolean syncUseDblock, int syncLockId) {
            this.pageSize = pageSize;
            this.forceFullSync = forceFullSync;
            this.syncInitialDelay = syncInitialDelay;
            this.syncPeriod = syncPeriod;
            this.syncUseDblock = syncUseDblock;
            this.syncLockId = syncLockId;
        }

        @Override
        public void run() {
            MirroredCrowdDirectoryBackend.this.directoryBackend.withWriteAccess(() -> {
                boolean gotLock = false;
                try {
                    if (this.syncUseDblock) {
                        MirroredCrowdDirectoryBackend.this.logger.info("Trying to acquire syncdblock.");
                        gotLock = MirroredCrowdDirectoryBackend.this.directoryBackend.acquireDbLock(this.syncLockId);
                        if (!gotLock) {
                            MirroredCrowdDirectoryBackend.this.logger.info("Did not get the syncdblock, run canceled.");
                            return;
                        }
                        MirroredCrowdDirectoryBackend.this.logger.info("Successfully acquired syncdblock.");
                    }
                    if (MirroredCrowdDirectoryBackend.this.directoryBackend.requireReset() && !this.resetToggle) {
                        this.forceFullSync = true;
                        this.resetToggle = true;
                    }
                    if (this.forceFullSync) {
                        MirroredCrowdDirectoryBackend.this.logger.info("Start forced synchronization of a full copy.");
                        this.performFullUpdate();
                        MirroredCrowdDirectoryBackend.this.logger.info("End forced synchronization of a full copy.");
                        this.forceFullSync = false;
                        MirroredCrowdDirectoryBackend.this.latch.countDown();
                        return;
                    }
                    AuditLogState state = MirroredCrowdDirectoryBackend.this.auditLogProcessor.getAuditLogState(true);
                    if (state.equals((Object)AuditLogState.FULL_UPDATE_REQUIRED)) {
                        MirroredCrowdDirectoryBackend.this.logger.info("Start synchronization of a full copy.");
                        this.performFullUpdate();
                        MirroredCrowdDirectoryBackend.this.logger.info("End synchronization of a full copy.");
                    } else if (state.equals((Object)AuditLogState.DELTA_UPDATE_REQUIRED)) {
                        MirroredCrowdDirectoryBackend.this.logger.info("Start incremental synchronization.");
                        this.performDeltaUpdate();
                        MirroredCrowdDirectoryBackend.this.logger.info("End incremental synchronization.");
                    }
                    MirroredCrowdDirectoryBackend.this.latch.countDown();
                }
                catch (Exception e) {
                    MirroredCrowdDirectoryBackend.this.logger.error("An error occurred during synchronization.", (Throwable)e);
                }
                finally {
                    if (this.syncUseDblock && gotLock) {
                        MirroredCrowdDirectoryBackend.this.directoryBackend.releaseDbLock(this.syncLockId);
                    }
                }
            });
        }

        private void performFullUpdate() {
            MirroredCrowdDirectoryBackend.this.auditLogProcessor.updateConcurrent(() -> {
                MirroredCrowdDirectoryBackend.this.directoryBackend.dropAllGroups();
                MirroredCrowdDirectoryBackend.this.directoryBackend.dropAllUsers();
                MappableCursor<MembershipEntity> memberships = MirroredCrowdDirectoryBackend.this.directoryBackend.getMemberships();
                int groupPage = 0;
                int userPage = 0;
                int groupCount = 0;
                int userCount = 0;
                while (groupPage != -1 || userPage != -1) {
                    if (groupPage >= 0) {
                        int groups = MirroredCrowdDirectoryBackend.this.directoryBackend.upsertAllGroups(groupPage++ * this.pageSize, this.pageSize);
                        groupCount += groups;
                        if (groups < this.pageSize) {
                            groupPage = -1;
                        }
                    }
                    if (userPage < 0) continue;
                    int users = MirroredCrowdDirectoryBackend.this.directoryBackend.upsertAllUsers(userPage++ * this.pageSize, this.pageSize);
                    userCount += users;
                    if (users >= this.pageSize) continue;
                    userPage = -1;
                }
                MirroredCrowdDirectoryBackend.this.logger.info("FullUpdate: received {} users and {} groups", (Object)userCount, (Object)groupCount);
                while (memberships.next()) {
                    MirroredCrowdDirectoryBackend.this.directoryBackend.upsertMembership(memberships.get());
                }
                return false;
            });
        }

        private void performDeltaUpdate() {
            LinkedList<Pair<UpdateType, Object>> deltaUpdateList = new LinkedList<Pair<UpdateType, Object>>();
            AuditLogState state = MirroredCrowdDirectoryBackend.this.auditLogProcessor.updateConcurrent(() -> {
                boolean committed = false;
                boolean lastPageDone = false;
                int page = 0;
                deltaUpdateList.clear();
                block2: while (!lastPageDone) {
                    JsonObject result;
                    try {
                        result = MirroredCrowdDirectoryBackend.this.auditLogProcessor.queryAuditLog(page, this.pageSize);
                        ++page;
                    }
                    catch (IOException e) {
                        MirroredCrowdDirectoryBackend.this.logger.error("Cannot call REST endpoint to query audit log for delta update.", (Throwable)e);
                        return true;
                    }
                    lastPageDone = result.getAsJsonObject().get("isLastPage").getAsBoolean();
                    for (JsonElement valueElement : result.getAsJsonArray("values")) {
                        String eventType = valueElement.getAsJsonObject().get("eventType").getAsString();
                        SyncState syncState = MirroredCrowdDirectoryBackend.this.auditLogProcessor.getSynchronizationState(valueElement);
                        if (syncState == SyncState.SYNC_COMPLETE) {
                            committed = true;
                            continue;
                        }
                        if (syncState == SyncState.SYNC_STOP && committed) {
                            lastPageDone = true;
                            continue block2;
                        }
                        if (syncState != SyncState.NO_SYNC) continue;
                        if (eventType.matches("(GROUP|USER)_(CREATED|UPDATED|DELETED)")) {
                            for (JsonElement entity : valueElement.getAsJsonObject().getAsJsonArray("entities")) {
                                String type = entity.getAsJsonObject().get("type").getAsString();
                                String name = entity.getAsJsonObject().get("name").getAsString();
                                if (type.equals("GROUP")) {
                                    if (eventType.equals("GROUP_CREATED") || eventType.equals("GROUP_UPDATED")) {
                                        deltaUpdateList.add(Pair.of((Object)((Object)UpdateType.GROUP_VALIDATE), (Object)name));
                                        continue;
                                    }
                                    if (!eventType.equals("GROUP_DELETED")) continue;
                                    deltaUpdateList.add(Pair.of((Object)((Object)UpdateType.GROUP_INVALIDATE), (Object)name));
                                    continue;
                                }
                                if (!type.equals("USER")) continue;
                                String alias = MirroredCrowdDirectoryBackend.this.auditLogProcessor.resolveToAlias(name);
                                if (eventType.equals("USER_UPDATED")) {
                                    Optional<JsonObject> property = StreamSupport.stream(valueElement.getAsJsonObject().getAsJsonArray("entries").spliterator(), false).map(JsonElement::getAsJsonObject).filter(x -> x.get("propertyName").getAsString().equalsIgnoreCase("username")).findAny();
                                    property.ifPresent(x -> {
                                        String nameOld = x.get("oldValue").getAsString();
                                        String aliasOld = MirroredCrowdDirectoryBackend.this.auditLogProcessor.resolveToAlias(nameOld);
                                        deltaUpdateList.add(Pair.of((Object)((Object)UpdateType.USER_INVALIDATE), (Object)aliasOld));
                                        deltaUpdateList.add(Pair.of((Object)((Object)UpdateType.USER_VALIDATE), (Object)Pair.of((Object)alias, (Object)aliasOld)));
                                    });
                                    if (!property.isEmpty()) continue;
                                    deltaUpdateList.add(Pair.of((Object)((Object)UpdateType.USER_VALIDATE), (Object)alias));
                                    continue;
                                }
                                if (eventType.equals("USER_CREATED")) {
                                    deltaUpdateList.add(Pair.of((Object)((Object)UpdateType.USER_VALIDATE), (Object)alias));
                                    continue;
                                }
                                if (!eventType.equals("USER_DELETED")) continue;
                                deltaUpdateList.add(Pair.of((Object)((Object)UpdateType.USER_INVALIDATE), (Object)alias));
                            }
                            continue;
                        }
                        if (!eventType.matches("(ADDED_TO|REMOVED_FROM)_GROUP")) continue;
                        String parentGroupId = null;
                        HashSet<String> childGroupIds = new HashSet<String>();
                        HashSet<String> userIds = new HashSet<String>();
                        for (JsonElement entity : valueElement.getAsJsonObject().getAsJsonArray("entities")) {
                            String type = entity.getAsJsonObject().get("type").getAsString();
                            String name = entity.getAsJsonObject().get("name").getAsString();
                            boolean primary = entity.getAsJsonObject().get("primary").getAsBoolean();
                            if (primary && type.equals("GROUP")) {
                                parentGroupId = name;
                                continue;
                            }
                            if (type.equals("GROUP")) {
                                childGroupIds.add(name);
                                continue;
                            }
                            if (!type.equals("USER")) continue;
                            userIds.add(MirroredCrowdDirectoryBackend.this.auditLogProcessor.resolveToAlias(name));
                        }
                        if (parentGroupId == null) {
                            MirroredCrowdDirectoryBackend.this.logger.warn("Cannot find parent group to create membership object.");
                            continue;
                        }
                        MembershipEntity membership = new MembershipEntity(parentGroupId, childGroupIds, userIds);
                        if (eventType.equals("ADDED_TO_GROUP")) {
                            deltaUpdateList.add(Pair.of((Object)((Object)UpdateType.MEMBERSHIP_VALIDATE), (Object)membership));
                            continue;
                        }
                        if (!eventType.equals("REMOVED_FROM_GROUP")) continue;
                        deltaUpdateList.add(Pair.of((Object)((Object)UpdateType.MEMBERSHIP_INVALIDATE), (Object)membership));
                    }
                }
                return false;
            });
            if (state.equals((Object)AuditLogState.CON_ISSUE)) {
                return;
            }
            this.downloadEntities(deltaUpdateList);
        }

        private void downloadEntities(List<Pair<UpdateType, Object>> deltaUpdateList) {
            for (Pair x : Lists.reverse(deltaUpdateList)) {
                if (((UpdateType)((Object)x.getLeft())).equals((Object)UpdateType.GROUP_VALIDATE) && x.getRight() instanceof String) {
                    MirroredCrowdDirectoryBackend.this.directoryBackend.upsertGroup(((String)x.getRight()).toLowerCase());
                    continue;
                }
                if (((UpdateType)((Object)x.getLeft())).equals((Object)UpdateType.GROUP_INVALIDATE) && x.getRight() instanceof String) {
                    MirroredCrowdDirectoryBackend.this.directoryBackend.dropGroup(((String)x.getRight()).toLowerCase());
                    continue;
                }
                if (((UpdateType)((Object)x.getLeft())).equals((Object)UpdateType.USER_VALIDATE) && x.getRight() instanceof String) {
                    MirroredCrowdDirectoryBackend.this.directoryBackend.upsertUser(((String)x.getRight()).toLowerCase());
                    continue;
                }
                if (((UpdateType)((Object)x.getLeft())).equals((Object)UpdateType.USER_VALIDATE) && x.getRight() instanceof Pair) {
                    String newName = ((Pair)x.getRight()).getLeft().toString();
                    String oldName = ((Pair)x.getRight()).getRight().toString();
                    MirroredCrowdDirectoryBackend.this.directoryBackend.upsertUser(newName.toLowerCase(), oldName.toLowerCase());
                    continue;
                }
                if (((UpdateType)((Object)x.getLeft())).equals((Object)UpdateType.USER_INVALIDATE) && x.getRight() instanceof String) {
                    MirroredCrowdDirectoryBackend.this.directoryBackend.dropUser(((String)x.getRight()).toLowerCase());
                    continue;
                }
                if (((UpdateType)((Object)x.getLeft())).equals((Object)UpdateType.MEMBERSHIP_VALIDATE) && x.getRight() instanceof MembershipEntity) {
                    MirroredCrowdDirectoryBackend.this.directoryBackend.upsertMembership((MembershipEntity)x.getRight());
                    continue;
                }
                if (!((UpdateType)((Object)x.getLeft())).equals((Object)UpdateType.MEMBERSHIP_INVALIDATE) || !(x.getRight() instanceof MembershipEntity)) continue;
                MirroredCrowdDirectoryBackend.this.directoryBackend.dropMembership((MembershipEntity)x.getRight());
            }
        }
    }

    private static enum AuditLogEntry {
        SYNC_START,
        SYNC_STOP,
        SYNC_COMPLETE;

    }

    private static enum SyncState {
        NO_SYNC,
        FOREIGN_SYNC,
        SYNC_START,
        SYNC_STOP,
        SYNC_COMPLETE;

    }

    private static enum AuditLogState {
        FULL_UPDATE_REQUIRED,
        DELTA_UPDATE_REQUIRED,
        UP_TO_DATE,
        CON_ISSUE,
        UNDEFINED;

    }

    private static enum UpdateType {
        GROUP_VALIDATE,
        GROUP_INVALIDATE,
        USER_VALIDATE,
        USER_INVALIDATE,
        MEMBERSHIP_VALIDATE,
        MEMBERSHIP_INVALIDATE;

    }
}

