/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.backend;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import technology.openpool.ldap.adapter.ServerConfiguration;
import technology.openpool.ldap.adapter.api.cursor.MappableCursor;
import technology.openpool.ldap.adapter.api.database.Row;
import technology.openpool.ldap.adapter.api.directory.NestedDirectoryBackend;
import technology.openpool.ldap.adapter.api.directory.exception.EntityNotFoundException;
import technology.openpool.ldap.adapter.api.entity.EntityType;
import technology.openpool.ldap.adapter.api.entity.GroupEntity;
import technology.openpool.ldap.adapter.api.entity.MembershipEntity;
import technology.openpool.ldap.adapter.api.entity.UserEntity;
import technology.openpool.ldap.adapter.api.query.QueryExpression;

public abstract class ProxyDirectoryBackend
implements NestedDirectoryBackend {
    protected final ServerConfiguration config;
    protected final NestedDirectoryBackend directoryBackend;

    protected ProxyDirectoryBackend(ServerConfiguration config, NestedDirectoryBackend directoryBackend) {
        this.config = config;
        this.directoryBackend = directoryBackend;
    }

    @Override
    public <T> T withReadAccess(Supplier<T> block) {
        return this.directoryBackend.withReadAccess(block);
    }

    @Override
    public void withReadAccess(Runnable block) {
        this.directoryBackend.withReadAccess(block);
    }

    @Override
    public <T> T withWriteAccess(Supplier<T> block) {
        return this.directoryBackend.withWriteAccess(block);
    }

    @Override
    public void withWriteAccess(Runnable block) {
        this.directoryBackend.withWriteAccess(block);
    }

    @Override
    public String getId() {
        return this.directoryBackend.getId();
    }

    @Override
    public void startup() {
        this.directoryBackend.startup();
    }

    @Override
    public void shutdown() {
        this.directoryBackend.shutdown();
    }

    @Override
    public boolean requireReset() {
        return this.directoryBackend.requireReset();
    }

    @Override
    public void upsertGroup(String id) {
        this.directoryBackend.upsertGroup(id);
    }

    @Override
    public int upsertAllGroups(int startIndex, int maxResults) {
        return this.directoryBackend.upsertAllGroups(startIndex, maxResults);
    }

    @Override
    public int upsertAllGroups() {
        return this.directoryBackend.upsertAllGroups();
    }

    @Override
    public void upsertUser(String id) {
        this.directoryBackend.upsertUser(id);
    }

    @Override
    public void upsertUser(String id, String idOther) {
        this.directoryBackend.upsertUser(id, idOther);
    }

    @Override
    public int upsertAllUsers(int startIndex, int maxResults) {
        return this.directoryBackend.upsertAllUsers(startIndex, maxResults);
    }

    @Override
    public int upsertAllUsers() {
        return this.directoryBackend.upsertAllUsers();
    }

    @Override
    public void upsertMembership(MembershipEntity membership) {
        this.directoryBackend.upsertMembership(membership);
    }

    @Override
    public void dropGroup(String id) {
        this.directoryBackend.dropGroup(id);
    }

    @Override
    public void dropAllGroups() {
        this.directoryBackend.dropAllGroups();
    }

    @Override
    public void dropUser(String id) {
        this.directoryBackend.dropUser(id);
    }

    @Override
    public void dropAllUsers() {
        this.directoryBackend.dropAllUsers();
    }

    @Override
    public void dropMembership(MembershipEntity membership) {
        this.directoryBackend.dropMembership(membership);
    }

    @Override
    public MappableCursor<Row> runQueryExpression(String txId, SchemaManager schemaManager, QueryExpression expression, EntityType entityType) {
        return this.directoryBackend.runQueryExpression(txId, schemaManager, expression, entityType);
    }

    @Override
    public GroupEntity getGroup(String id) throws EntityNotFoundException {
        return this.directoryBackend.getGroup(id);
    }

    @Override
    public UserEntity getUser(String id) throws EntityNotFoundException {
        return this.directoryBackend.getUser(id);
    }

    @Override
    public UserEntity getAuthenticatedUser(String id, String password) throws EntityNotFoundException {
        return this.directoryBackend.getAuthenticatedUser(id, password);
    }

    @Override
    public Set<GroupEntity> getAllGroups() {
        return this.directoryBackend.getAllGroups();
    }

    @Override
    public Set<GroupEntity> getAllGroups(int startIndex, int maxResults) {
        return this.directoryBackend.getAllGroups(startIndex, maxResults);
    }

    @Override
    public Set<UserEntity> getAllUsers() {
        return this.directoryBackend.getAllUsers();
    }

    @Override
    public Set<UserEntity> getAllUsers(int startIndex, int maxResults) {
        return this.directoryBackend.getAllUsers(startIndex, maxResults);
    }

    @Override
    public Set<UserEntity> getDirectUsersOfGroup(String id) throws EntityNotFoundException {
        return this.directoryBackend.getDirectUsersOfGroup(id);
    }

    @Override
    public Set<GroupEntity> getDirectGroupsOfUser(String id) throws EntityNotFoundException {
        return this.directoryBackend.getDirectGroupsOfUser(id);
    }

    @Override
    public Set<UserEntity> getTransitiveUsersOfGroup(String id) throws EntityNotFoundException {
        return this.directoryBackend.getTransitiveUsersOfGroup(id);
    }

    @Override
    public Set<GroupEntity> getTransitiveGroupsOfUser(String id) throws EntityNotFoundException {
        return this.directoryBackend.getTransitiveGroupsOfUser(id);
    }

    @Override
    public Set<GroupEntity> getDirectChildGroupsOfGroup(String id) throws EntityNotFoundException {
        return this.directoryBackend.getDirectChildGroupsOfGroup(id);
    }

    @Override
    public Set<GroupEntity> getDirectParentGroupsOfGroup(String id) throws EntityNotFoundException {
        return this.directoryBackend.getDirectParentGroupsOfGroup(id);
    }

    @Override
    public Set<GroupEntity> getTransitiveChildGroupsOfGroup(String id) throws EntityNotFoundException {
        return this.directoryBackend.getTransitiveChildGroupsOfGroup(id);
    }

    @Override
    public Set<GroupEntity> getTransitiveParentGroupsOfGroup(String id) throws EntityNotFoundException {
        return this.directoryBackend.getTransitiveParentGroupsOfGroup(id);
    }

    @Override
    public MappableCursor<MembershipEntity> getMemberships() {
        return this.directoryBackend.getMemberships();
    }
}

