/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.sql.impl;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import technology.openpool.ldap.adapter.api.database.CloseableTransaction;
import technology.openpool.ldap.adapter.api.database.QueryDefFactory;
import technology.openpool.ldap.adapter.api.database.Transactional;
import technology.openpool.ldap.adapter.api.database.exception.UncheckedSQLException;
import technology.openpool.ldap.adapter.api.database.result.IgnoredResult;
import technology.openpool.ldap.adapter.api.database.result.IndexedSeqResult;
import technology.openpool.ldap.adapter.sql.impl.Executor;

public class DatabaseService
implements Transactional {
    private final Logger logger;
    private final BasicDataSource dataSource;
    private boolean updatedSchema = false;
    private final boolean applyNativeSql;
    private static final String QUERIES_CLAUSES = "technology/openpool/ldap/adapter/db/queries.sql";
    private static final String VERSIONING_SCHEMA_CLAUSES = "technology/openpool/ldap/adapter/db/versioning-schema.sql";
    private static final String CREATE_SCHEMA_CLAUSES = "technology/openpool/ldap/adapter/db/create-schema.sql";
    private static final String DROP_SCHEMA_CLAUSES = "technology/openpool/ldap/adapter/db/drop-schema.sql";

    public DatabaseService(Logger logger, String driver, String url, String user, String password, int minIdle, int maxIdle, int maxTotal, int maxOpenPreparedStatements, int isolationLevel, boolean applyNativeSql) {
        this.logger = logger;
        this.dataSource = new BasicDataSource();
        this.dataSource.setDriverClassName(driver);
        this.dataSource.setUrl(url);
        this.dataSource.setUsername(user);
        this.dataSource.setPassword(password);
        this.dataSource.setMinIdle(minIdle);
        this.dataSource.setMaxIdle(maxIdle);
        this.dataSource.setMaxTotal(maxTotal);
        this.dataSource.setMaxOpenPreparedStatements(maxOpenPreparedStatements);
        this.dataSource.setDefaultTransactionIsolation(isolationLevel);
        this.applyNativeSql = applyNativeSql;
        System.setProperty("org.jooq.no-logo", "true");
    }

    public void startup() {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new UncheckedSQLException("Could not create connection from pool.", e);
        }
        Executor executor = new Executor(this.logger, connection, VERSIONING_SCHEMA_CLAUSES);
        this.performSchemaEvolution(executor.newQueryDefFactory());
    }

    public void shutdown() {
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            throw new UncheckedSQLException("Cannot release connection pool.", e);
        }
    }

    public boolean hasUpdatedSchema() {
        return this.updatedSchema;
    }

    @Override
    public <T> T withTransaction(Function<QueryDefFactory, T> block) {
        T result;
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new UncheckedSQLException("Could not create connection from pool.", e);
        }
        Executor executor = new Executor(this.logger, connection, QUERIES_CLAUSES);
        long start = System.currentTimeMillis();
        try {
            executor.getConnection().setAutoCommit(false);
            result = block.apply(executor.newQueryDefFactory());
            executor.getConnection().commit();
        }
        catch (Exception e1) {
            try {
                executor.getConnection().rollback();
                throw e1;
            }
            catch (SQLException e2) {
                throw new UncheckedSQLException(e2);
            }
        }
        finally {
            try {
                executor.getConnection().close();
            }
            catch (SQLException e) {
                this.logger.error("Cannot close database connection.", (Throwable)e);
            }
        }
        long end = System.currentTimeMillis();
        this.logger.debug("[Thread ID {}] - A transaction was performed in {} ms.", (Object)Thread.currentThread().getId(), (Object)(end - start == 0L ? 1L : end - start));
        return result;
    }

    @Override
    public void withTransaction(Consumer<QueryDefFactory> block) {
        this.withTransaction((QueryDefFactory x) -> {
            block.accept((QueryDefFactory)x);
            return null;
        });
    }

    @Override
    public CloseableTransaction getCloseableTransaction() {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new UncheckedSQLException("Could not create connection from pool.", e);
        }
        final Executor executor = new Executor(this.logger, connection, QUERIES_CLAUSES);
        try {
            executor.getConnection().setAutoCommit(false);
        }
        catch (SQLException e) {
            try {
                executor.getConnection().close();
            }
            catch (SQLException e2) {
                this.logger.error("Cannot close database connection.", (Throwable)e2);
            }
            throw new UncheckedSQLException("Could not trigger transactional processing.", e);
        }
        return new CloseableTransaction(){

            @Override
            public QueryDefFactory getQueryDefFactory() {
                return executor.newQueryDefFactory();
            }

            @Override
            public void close() throws IOException {
                try {
                    executor.getConnection().commit();
                }
                catch (SQLException e) {
                    throw new UncheckedSQLException(e);
                }
                finally {
                    try {
                        executor.getConnection().close();
                    }
                    catch (SQLException e) {
                        DatabaseService.this.logger.error("Cannot close database connection.", (Throwable)e);
                    }
                }
            }

            @Override
            public void close(Exception cause) throws IOException {
                DatabaseService.this.logger.warn("Rollback transaction with internal error.", (Throwable)cause);
                try {
                    executor.getConnection().rollback();
                }
                catch (SQLException e) {
                    throw new UncheckedSQLException(e);
                }
                finally {
                    try {
                        executor.getConnection().close();
                    }
                    catch (SQLException e) {
                        DatabaseService.this.logger.error("Cannot close database connection.", (Throwable)e);
                    }
                }
                throw new IOException(cause);
            }
        };
    }

    private void performSchemaEvolution(QueryDefFactory factory) {
        factory.queryById("create_schema_version_table").execute(IgnoredResult.class);
        if (!this.isSchemaUpToDate(factory)) {
            this.renewSchema(factory);
            this.updatedSchema = true;
        }
    }

    private boolean isSchemaUpToDate(QueryDefFactory factory) {
        List<Byte> hash = this.getSchemaVersion();
        return factory.queryById("get_schema_version").execute(IndexedSeqResult.class).transform(row -> row.apply("hash", List.class)).stream().findFirst().map(x -> x.equals(hash)).orElse(false);
    }

    private void renewSchema(QueryDefFactory factory) {
        List<Byte> hash = this.getSchemaVersion();
        this.runBatch(factory, DROP_SCHEMA_CLAUSES);
        this.runBatch(factory, CREATE_SCHEMA_CLAUSES);
        factory.queryById("set_schema_version").on("hash", hash).on("created_at", LocalDateTime.now().withNano(0)).execute(IgnoredResult.class);
    }

    private List<Byte> getSchemaVersion() {
        ArrayList<Byte> arrayList;
        block9: {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(CREATE_SCHEMA_CLAUSES);
            try {
                String result = IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                Object[] hash = ArrayUtils.toObject((byte[])digest.digest(result.getBytes(StandardCharsets.UTF_8)));
                arrayList = new ArrayList<Byte>((Collection<Byte>)ImmutableList.copyOf((Object[])hash));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return arrayList;
    }

    private void runBatch(QueryDefFactory factory, String resourcePath) {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);){
            String result = IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
            Arrays.stream(result.split(";")).map(String::trim).filter(x -> !x.isEmpty()).filter(x -> !x.startsWith("NATIVE_SQL:") || this.applyNativeSql).forEach(queryClause -> factory.query(queryClause.trim()).execute(IgnoredResult.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

