/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.sql.impl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jooq.Query;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import technology.openpool.ldap.adapter.api.cursor.MappableCursor;
import technology.openpool.ldap.adapter.api.database.QueryDef;
import technology.openpool.ldap.adapter.api.database.QueryDefFactory;
import technology.openpool.ldap.adapter.api.database.Row;
import technology.openpool.ldap.adapter.api.database.exception.UncheckedSQLException;
import technology.openpool.ldap.adapter.api.database.exception.UnknownColumnException;
import technology.openpool.ldap.adapter.api.database.result.CursorResult;
import technology.openpool.ldap.adapter.api.database.result.IgnoredResult;
import technology.openpool.ldap.adapter.api.database.result.IndexedNonEmptySeqResult;
import technology.openpool.ldap.adapter.api.database.result.IndexedSeqResult;
import technology.openpool.ldap.adapter.api.database.result.Result;
import technology.openpool.ldap.adapter.api.database.result.SingleOptResult;
import technology.openpool.ldap.adapter.api.database.result.SingleResult;

public class Executor {
    private final Logger logger;
    private final Connection connection;
    private final Map<String, String> clauses;
    public static final String NATIVE_SQL_INDICATOR = "NATIVE_SQL:";

    public Executor(Logger logger, Connection connection, String resourcePath) {
        this.logger = logger;
        this.connection = connection;
        this.clauses = this.parseSqlFile(resourcePath);
    }

    public <T extends Result> T executeById(String clauseId, Map<String, Object> parameters, Class<T> clazz) throws SQLException {
        String clause = this.clauses.get(clauseId);
        if (clause == null) {
            throw new IllegalArgumentException("Cannot find clause with ID " + clauseId);
        }
        return this.execute(clause, parameters, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T extends Result> T execute(String clause, Map<String, Object> parameters, Class<T> clazz) throws SQLException {
        IgnoredResult ignoredResult;
        PreparedStatement statement;
        boolean nonStreamed;
        long start;
        Query query;
        block29: {
            block30: {
                block28: {
                    Result concreteResult;
                    query = null;
                    String sql = null;
                    start = System.currentTimeMillis();
                    nonStreamed = true;
                    String trimmedClause = clause.trim();
                    if (trimmedClause.startsWith(NATIVE_SQL_INDICATOR)) {
                        sql = trimmedClause.substring(NATIVE_SQL_INDICATOR.length()).trim();
                    } else {
                        this.logger.debug("[Thread ID {}] - Parse dialect free SQL statement:\n{}", (Object)Thread.currentThread().getId(), (Object)trimmedClause);
                        query = DSL.using((Connection)this.connection).parser().parseQuery(trimmedClause);
                    }
                    if (query != null) {
                        this.findBinding(query, parameters);
                        sql = query.getSQL();
                    }
                    final Query finalQuery = query;
                    this.logger.debug("[Thread ID {}] - Apply dialect specific SQL statement:\n{}", (Object)Thread.currentThread().getId(), (Object)sql);
                    statement = this.connection.prepareStatement(sql);
                    if (query != null) {
                        this.setValues(statement, query.getBindValues());
                    } else {
                        this.setValues(statement, parameters);
                    }
                    this.logger.debug("Native SQL for Statement: {}", (Object)statement);
                    statement.execute();
                    if (clazz == IgnoredResult.class) {
                        concreteResult = new IgnoredResult(){};
                    } else {
                        LinkedHashMap<String, JDBCType> metadata = this.getMetadata(statement);
                        final ArrayList<String> columnNames = new ArrayList<String>(metadata.keySet());
                        final MappableCursor<Row> cursor = this.getRowCursor(statement, metadata);
                        if (clazz == SingleResult.class) {
                            final ArrayList rows = Lists.newArrayList(cursor.iterator(x -> new RowProxyImpl((Row)x, (List<String>)columnNames)));
                            if (rows.size() != 1) {
                                throw new IllegalArgumentException("Expect set of rows with cardinality of 1 but " + rows.size() + " received.");
                            }
                            concreteResult = new SingleResult(){

                                @Override
                                public List<String> getColumns() {
                                    return columnNames;
                                }

                                public <R> R transform(Function<Row, R> f) {
                                    return rows.stream().map(f).findAny().get();
                                }
                            };
                        } else if (clazz == SingleOptResult.class) {
                            final ArrayList rows = Lists.newArrayList(cursor.iterator(x -> new RowProxyImpl((Row)x, (List<String>)columnNames)));
                            if (rows.size() > 1) {
                                throw new IllegalArgumentException("Expect set of rows with cardinality of 0 or 1 but " + rows.size() + " received.");
                            }
                            concreteResult = new SingleOptResult(){

                                @Override
                                public List<String> getColumns() {
                                    return columnNames;
                                }

                                public <R> Optional<R> transform(Function<Row, R> f) {
                                    return rows.stream().map(f).findAny();
                                }
                            };
                        } else if (clazz == IndexedSeqResult.class) {
                            final ArrayList rows = Lists.newArrayList(cursor.iterator(x -> new RowProxyImpl((Row)x, (List<String>)columnNames)));
                            concreteResult = new IndexedSeqResult(){

                                @Override
                                public List<String> getColumns() {
                                    return columnNames;
                                }

                                public <R> List<R> transform(Function<Row, R> f) {
                                    return rows.stream().map(f).collect(Collectors.toList());
                                }
                            };
                        } else if (clazz == IndexedNonEmptySeqResult.class) {
                            final ArrayList rows = Lists.newArrayList(cursor.iterator(x -> new RowProxyImpl((Row)x, (List<String>)columnNames)));
                            if (rows.isEmpty()) {
                                throw new IllegalArgumentException("Expect set of rows with cardinality greater than 1 but " + rows.size() + " received.");
                            }
                            concreteResult = new IndexedNonEmptySeqResult(){

                                @Override
                                public List<String> getColumns() {
                                    return columnNames;
                                }

                                public <R> List<R> transform(Function<Row, R> f) {
                                    return rows.stream().map(f).collect(Collectors.toList());
                                }
                            };
                        } else if (clazz == CursorResult.class) {
                            concreteResult = new CursorResult(){

                                @Override
                                public List<String> getColumns() {
                                    return columnNames;
                                }

                                public <R> MappableCursor<R> transform(Function<Row, R> f) {
                                    final MappableCursor<R> underlying = cursor.map(f);
                                    return new MappableCursor<R>(){
                                        boolean closed = false;

                                        @Override
                                        public boolean next() {
                                            return underlying.next();
                                        }

                                        @Override
                                        public R get() {
                                            return underlying.get();
                                        }

                                        @Override
                                        public void close() throws IOException {
                                            if (!this.closed) {
                                                try {
                                                    statement.close();
                                                    underlying.close();
                                                    if (finalQuery != null) {
                                                        finalQuery.close();
                                                    }
                                                }
                                                catch (SQLException | DataAccessException e) {
                                                    throw new IOException("Could not close prepared statement", e);
                                                }
                                                this.closed = true;
                                            }
                                        }
                                    };
                                }
                            };
                            nonStreamed = false;
                        } else {
                            throw new IllegalArgumentException("Unsupported type of result class.");
                        }
                    }
                    ignoredResult = concreteResult;
                    if (!nonStreamed) break block28;
                    statement.close();
                }
                if (!nonStreamed) break block29;
                if (query == null) break block30;
                query.close();
            }
            long end = System.currentTimeMillis();
            this.logger.debug("[Thread ID {}] - A prepared statement was performed in {} ms.", (Object)Thread.currentThread().getId(), (Object)(end - start == 0L ? 1L : end - start));
        }
        return (T)ignoredResult;
        {
            catch (Throwable throwable) {
                try {
                    if (nonStreamed) {
                        statement.close();
                    }
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (nonStreamed) {
                        if (query != null) {
                            query.close();
                        }
                        long end2 = System.currentTimeMillis();
                        this.logger.debug("[Thread ID {}] - A prepared statement was performed in {} ms.", (Object)Thread.currentThread().getId(), (Object)(end2 - start == 0L ? 1L : end2 - start));
                    }
                    throw throwable2;
                }
            }
        }
    }

    public QueryDefFactory newQueryDefFactory() {
        return new QueryDefFactory(){

            @Override
            public QueryDef queryById(String clauseId) {
                return new QueryDefImpl(clauseId, Collections.emptyMap(), true);
            }

            @Override
            public QueryDef query(String clause) {
                return new QueryDefImpl(clause, Collections.emptyMap(), false);
            }
        };
    }

    public Connection getConnection() {
        return this.connection;
    }

    private void findBinding(Query query, Map<String, Object> parameters) {
        parameters.forEach((k, v) -> this.findBinding(query, (String)k, v));
    }

    private void findBinding(Query query, String key, Object value) {
        if (value == null) {
            query.bind(key, null);
        } else if (value instanceof Character) {
            query.bind(key, (Object)value.toString());
        } else if (value instanceof LocalDate) {
            query.bind(key, (Object)Date.valueOf((LocalDate)value));
        } else if (value instanceof LocalTime) {
            query.bind(key, (Object)Time.valueOf((LocalTime)value));
        } else if (value instanceof LocalDateTime) {
            query.bind(key, (Object)Timestamp.valueOf((LocalDateTime)value));
        } else if (this.isByteSequence(value)) {
            query.bind(key, (Object)this.toByteArray(value));
        } else if (value instanceof Optional) {
            this.findBinding(query, key, ((Optional)value).orElse(null));
        } else {
            query.bind(key, value);
        }
    }

    private void setValues(PreparedStatement statement, List<Object> parameters) throws SQLException {
        int key = 0;
        for (Object x : parameters) {
            this.setValue(statement, ++key, x);
        }
    }

    private void setValues(PreparedStatement statement, Map<String, Object> parameters) throws SQLException {
        int key = 0;
        for (Map.Entry<String, Object> x : parameters.entrySet()) {
            this.setValue(statement, ++key, x.getValue());
        }
    }

    private void setValue(PreparedStatement statement, int key, Object value) throws SQLException {
        if (value == null) {
            statement.setNull(key, JDBCType.NULL.getVendorTypeNumber());
        } else if (value instanceof Boolean) {
            statement.setBoolean(key, (Boolean)value);
        } else if (value instanceof Byte) {
            statement.setByte(key, (Byte)value);
        } else if (value instanceof Short) {
            statement.setShort(key, (Short)value);
        } else if (value instanceof Integer) {
            statement.setInt(key, (Integer)value);
        } else if (value instanceof Long) {
            statement.setLong(key, (Long)value);
        } else if (value instanceof Float) {
            statement.setFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            statement.setDouble(key, (Double)value);
        } else if (value instanceof Character) {
            statement.setString(key, String.valueOf(((Character)value).charValue()));
        } else if (value instanceof String) {
            statement.setString(key, (String)value);
        } else if (value instanceof BigDecimal) {
            statement.setBigDecimal(key, (BigDecimal)value);
        } else if (value instanceof LocalDate) {
            statement.setDate(key, Date.valueOf((LocalDate)value));
        } else if (value instanceof LocalTime) {
            statement.setTime(key, Time.valueOf((LocalTime)value));
        } else if (value instanceof LocalDateTime) {
            statement.setTimestamp(key, Timestamp.valueOf((LocalDateTime)value));
        } else if (value instanceof Date) {
            statement.setDate(key, (Date)value);
        } else if (value instanceof Time) {
            statement.setTime(key, (Time)value);
        } else if (value instanceof Timestamp) {
            statement.setTimestamp(key, (Timestamp)value);
        } else if (this.isByteSequence(value)) {
            statement.setBytes(key, this.toByteArray(value));
        } else if (value instanceof Optional) {
            this.setValue(statement, key, ((Optional)value).orElse(null));
        } else {
            throw new IllegalArgumentException("Cannot put unsupported type with value " + value + " (" + value.getClass().getName() + ") at key " + key + ".");
        }
    }

    private Object getColumnValue(String columnName, ResultSet resultSet, Map<String, JDBCType> metadata) throws SQLException {
        Object result;
        String lowerColumnName = columnName.toLowerCase();
        JDBCType jdbcType = metadata.get(lowerColumnName);
        if (jdbcType == null) {
            throw new UnknownColumnException("Cannot find column " + lowerColumnName + " in current row.");
        }
        if (jdbcType == JDBCType.NULL) {
            result = null;
        } else if (jdbcType == JDBCType.BIT) {
            result = resultSet.getBoolean(lowerColumnName);
        } else if (jdbcType == JDBCType.BOOLEAN) {
            result = resultSet.getBoolean(lowerColumnName);
        } else if (jdbcType == JDBCType.TINYINT) {
            result = resultSet.getByte(lowerColumnName);
        } else if (jdbcType == JDBCType.SMALLINT) {
            result = resultSet.getShort(lowerColumnName);
        } else if (jdbcType == JDBCType.INTEGER) {
            result = resultSet.getInt(lowerColumnName);
        } else if (jdbcType == JDBCType.BIGINT) {
            result = resultSet.getLong(lowerColumnName);
        } else if (jdbcType == JDBCType.REAL) {
            result = Float.valueOf(resultSet.getFloat(lowerColumnName));
        } else if (jdbcType == JDBCType.FLOAT) {
            result = resultSet.getDouble(lowerColumnName);
        } else if (jdbcType == JDBCType.DOUBLE) {
            result = resultSet.getDouble(lowerColumnName);
        } else if (jdbcType == JDBCType.NUMERIC) {
            result = resultSet.getBigDecimal(lowerColumnName);
        } else if (jdbcType == JDBCType.DECIMAL) {
            result = resultSet.getBigDecimal(lowerColumnName);
        } else if (jdbcType == JDBCType.DATE) {
            result = resultSet.getDate(lowerColumnName).toLocalDate();
        } else if (jdbcType == JDBCType.TIME) {
            result = resultSet.getTime(lowerColumnName).toLocalTime();
        } else if (jdbcType == JDBCType.TIMESTAMP) {
            result = resultSet.getTimestamp(lowerColumnName).toLocalDateTime();
        } else if (jdbcType == JDBCType.BINARY) {
            result = this.toByteList(resultSet.getBytes(lowerColumnName));
        } else if (jdbcType == JDBCType.VARBINARY) {
            result = this.toByteList(resultSet.getBytes(lowerColumnName));
        } else if (jdbcType == JDBCType.LONGVARBINARY) {
            result = this.toByteList(resultSet.getBytes(lowerColumnName));
        } else if (jdbcType == JDBCType.BLOB) {
            result = resultSet.getBytes(lowerColumnName);
        } else if (jdbcType == JDBCType.CHAR) {
            result = resultSet.getString(lowerColumnName);
        } else if (jdbcType == JDBCType.VARCHAR) {
            result = resultSet.getString(lowerColumnName);
        } else if (jdbcType == JDBCType.LONGVARCHAR) {
            result = resultSet.getString(lowerColumnName);
        } else if (jdbcType == JDBCType.CLOB) {
            result = resultSet.getString(lowerColumnName);
        } else if (jdbcType == JDBCType.NCHAR) {
            result = resultSet.getString(lowerColumnName);
        } else if (jdbcType == JDBCType.NVARCHAR) {
            result = resultSet.getString(lowerColumnName);
        } else if (jdbcType == JDBCType.LONGNVARCHAR) {
            result = resultSet.getString(lowerColumnName);
        } else if (jdbcType == JDBCType.NCLOB) {
            result = resultSet.getString(lowerColumnName);
        } else {
            throw new IllegalArgumentException("Cannot set unsupported JDBC type " + jdbcType.getName() + " for column " + lowerColumnName + ".");
        }
        return result;
    }

    private MappableCursor<Row> getRowCursor(PreparedStatement statement, Map<String, JDBCType> metadata) throws SQLException {
        final ResultSet resultSet = statement.getResultSet();
        final RowImpl row = new RowImpl(resultSet, metadata);
        return new MappableCursor<Row>(){

            @Override
            public boolean next() {
                try {
                    return resultSet.next();
                }
                catch (SQLException e) {
                    throw new UncheckedSQLException(e);
                }
            }

            @Override
            public Row get() {
                return row;
            }
        };
    }

    private LinkedHashMap<String, JDBCType> getMetadata(PreparedStatement statement) throws SQLException {
        LinkedHashMap<String, JDBCType> result = new LinkedHashMap<String, JDBCType>();
        ResultSetMetaData metadata = statement.getMetaData();
        if (metadata == null) {
            return result;
        }
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String lowerColumnName = metadata.getColumnLabel(i).toLowerCase();
            if (result.containsKey(lowerColumnName)) {
                throw new IllegalArgumentException("Expect unique column name for resulting rows.");
            }
            result.put(lowerColumnName, JDBCType.valueOf(metadata.getColumnType(i)));
        }
        return result;
    }

    private boolean isByteSequence(Object obj) {
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            return collection.stream().allMatch(x -> x instanceof Byte);
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                if (Array.get(obj, i) instanceof Byte) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private byte[] toByteArray(Object obj) {
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            Iterator iter = collection.iterator();
            byte[] array = new byte[collection.size()];
            int i = 0;
            while (iter.hasNext()) {
                array[i] = (Byte)iter.next();
                ++i;
            }
            return array;
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            byte[] array = new byte[length];
            for (int i = 0; i < length; ++i) {
                array[i] = (Byte)Array.get(obj, i);
            }
            return array;
        }
        throw new IllegalArgumentException("Cannot create byte array from object.");
    }

    private List<Byte> toByteList(byte[] array) {
        ArrayList<Byte> list = new ArrayList<Byte>(array.length);
        for (byte b : array) {
            list.add(b);
        }
        return list;
    }

    private Map<String, String> parseSqlFile(String resourcePath) {
        String headerStart = "--[ID:";
        String headerEnd = "]--";
        HashMap<String, String> mapping = new HashMap<String, String>();
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);){
            String result = IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
            int pos = result.indexOf(headerStart);
            while (pos != -1) {
                int endPos = result.indexOf(headerEnd, pos + headerStart.length());
                if (endPos == -1) {
                    throw new IllegalArgumentException("Missing ending of all clause headers.");
                }
                String id = result.substring(pos + headerStart.length(), endPos).trim();
                if (id.isEmpty()) {
                    throw new IllegalArgumentException("Expect an ID for all clauses.");
                }
                pos = result.indexOf(headerStart, endPos + headerEnd.length());
                String clause = pos == -1 ? result.substring(endPos + headerEnd.length()).trim() : result.substring(endPos + headerEnd.length(), pos).trim();
                if (clause.isEmpty()) {
                    throw new IllegalArgumentException("Expect non empty clauses.");
                }
                mapping.put(id, clause);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return mapping;
    }

    private class QueryDefImpl
    implements QueryDef {
        private final String clauseOrId;
        private final Map<String, Object> parameters;
        private final boolean byId;

        public QueryDefImpl(String clauseOrId, Map<String, Object> parameters, boolean byId) {
            this.clauseOrId = clauseOrId;
            this.parameters = parameters;
            this.byId = byId;
        }

        @Override
        public QueryDefImpl on(String key, Object value) {
            HashMap<String, Object> parameters = new HashMap<String, Object>(this.parameters);
            parameters.put(key, value);
            return new QueryDefImpl(this.clauseOrId, parameters, this.byId);
        }

        @Override
        public QueryDef on(List<Object> arguments) {
            HashMap<String, Object> parameters = new HashMap<String, Object>(this.parameters);
            int index = 1;
            for (Object argument : arguments) {
                parameters.put(Integer.toString(index++), argument);
            }
            return new QueryDefImpl(this.clauseOrId, parameters, this.byId);
        }

        @Override
        public <T extends Result> T execute(Class<T> clazz) {
            try {
                if (this.byId) {
                    return Executor.this.executeById(this.clauseOrId, this.parameters, clazz);
                }
                return Executor.this.execute(this.clauseOrId, this.parameters, clazz);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        }

        @Override
        public <T extends Result> T executeWithAutoCommit(Class<T> clazz) {
            try {
                boolean commitState = Executor.this.connection.getAutoCommit();
                Executor.this.connection.setAutoCommit(true);
                T result = this.byId ? Executor.this.executeById(this.clauseOrId, this.parameters, clazz) : Executor.this.execute(this.clauseOrId, this.parameters, clazz);
                Executor.this.connection.setAutoCommit(commitState);
                return (T)((Result)result);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            QueryDefImpl queryDef = (QueryDefImpl)that;
            return this.byId == queryDef.byId && Objects.equals(this.clauseOrId, queryDef.clauseOrId) && Objects.equals(this.parameters, queryDef.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.clauseOrId, this.parameters, this.byId);
        }
    }

    private class RowProxyImpl
    implements Row {
        private final Map<String, Object> underlying = new LinkedHashMap<String, Object>();

        public RowProxyImpl(Row row, List<String> columnNames) {
            columnNames.forEach(x -> this.underlying.put((String)x, row.apply((String)x, Object.class)));
        }

        @Override
        public <T> T apply(String columnName, Class<T> clazz) {
            String lowerColumnName = columnName;
            if (!this.underlying.containsKey(lowerColumnName)) {
                throw new UnknownColumnException("Cannot find column " + lowerColumnName + " in current row.");
            }
            Object result = this.underlying.get(lowerColumnName);
            if (result == null) {
                return null;
            }
            try {
                return (T)result;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Cannot perform a read conversion with column " + columnName + " and with type [" + clazz.getName() + "].", e);
            }
        }
    }

    private class RowImpl
    implements Row {
        private final ResultSet resultSet;
        private final Map<String, JDBCType> metadata;

        public RowImpl(ResultSet resultSet, Map<String, JDBCType> metadata) {
            this.resultSet = resultSet;
            this.metadata = metadata;
        }

        @Override
        public <T> T apply(String columnName, Class<T> clazz) {
            Object result;
            try {
                result = Executor.this.getColumnValue(columnName, this.resultSet, this.metadata);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
            if (result == null) {
                return null;
            }
            try {
                return (T)result;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Cannot perform a read conversion with column " + columnName + " and with type [" + clazz.getName() + "].", e);
            }
        }
    }
}

