/*
 * Decompiled with CFR 0.152.
 */
package technology.openpool.ldap.adapter.sql.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import technology.openpool.ldap.adapter.api.LdapUtils;
import technology.openpool.ldap.adapter.api.database.QueryDef;
import technology.openpool.ldap.adapter.api.database.QueryDefFactory;
import technology.openpool.ldap.adapter.api.entity.EntityType;
import technology.openpool.ldap.adapter.api.query.AndLogicExpression;
import technology.openpool.ldap.adapter.api.query.BinaryOperator;
import technology.openpool.ldap.adapter.api.query.BooleanValue;
import technology.openpool.ldap.adapter.api.query.EqualOperator;
import technology.openpool.ldap.adapter.api.query.NotLogicExpression;
import technology.openpool.ldap.adapter.api.query.OperatorExpression;
import technology.openpool.ldap.adapter.api.query.OrLogicExpression;
import technology.openpool.ldap.adapter.api.query.PresenceOperator;
import technology.openpool.ldap.adapter.api.query.QueryExpression;
import technology.openpool.ldap.adapter.api.query.WildcardOperator;

public class QueryGenerator {
    private static final int GROUP_MEMBER_OF_FLAG = 1;
    private static final int USER_MEMBER_OF_FLAG = 2;
    private static final int GROUP_MEMBER_GROUP_FLAG = 4;
    private static final int GROUP_MEMBER_USER_FLAG = 8;
    private final SchemaManager schemaManager;
    private final String dcId;
    private final boolean flattening;
    private final boolean activeUsersOnly;
    private final boolean useMaterializedViews;

    public QueryGenerator(SchemaManager schemaManager, String dcId, boolean flattening, boolean activeUsersOnly, boolean useMaterializedViews) {
        this.schemaManager = schemaManager;
        this.dcId = dcId;
        this.flattening = flattening;
        this.activeUsersOnly = activeUsersOnly;
        this.useMaterializedViews = useMaterializedViews;
    }

    public QueryDef generate(EntityType entityType, QueryDefFactory factory, QueryExpression expression) {
        if (entityType == EntityType.GROUP) {
            expression = LdapUtils.preEvaluateExpressionForGroup(expression);
        } else if (entityType == EntityType.USER) {
            expression = LdapUtils.preEvaluateExpressionForUser(expression);
        } else {
            throw new IllegalArgumentException("Expect supported entity type.");
        }
        expression = LdapUtils.removeNotExpressions(LdapUtils.removeValueExpressions(expression));
        StringBuilder builder = new StringBuilder();
        ArrayList<Object> arguments = new ArrayList<Object>();
        int joinPlan = this.createJoinPlan(entityType);
        this.generateSelectClause(builder, entityType, joinPlan, arguments);
        this.generateJoinClauses(builder, entityType, joinPlan);
        this.generateWhereClause(builder, entityType, joinPlan, expression, arguments);
        this.generateOrderByClause(builder, entityType);
        return factory.query(builder.toString()).on(arguments);
    }

    private int createJoinPlan(EntityType entityType) {
        int mask = 0;
        if (entityType == EntityType.GROUP) {
            mask |= 8;
        }
        if (entityType == EntityType.GROUP && !this.flattening) {
            mask |= 5;
        }
        if (entityType == EntityType.USER) {
            mask |= 2;
        }
        return mask;
    }

    private void generateSelectClause(StringBuilder builder, EntityType entityType, int joinPlan, List<Object> arguments) {
        if (entityType == EntityType.GROUP) {
            builder.append("select ? as type, g.*");
            arguments.add(EntityType.GROUP.toString().toLowerCase());
            if ((joinPlan & 1) != 0) {
                builder.append(", gp.name as parent_group_name");
            }
            if ((joinPlan & 4) != 0) {
                builder.append(", gc.name as member_group_name");
            }
            if ((joinPlan & 8) != 0) {
                builder.append(", u.username as member_user_username");
            }
            builder.append(" from _Group g ");
        } else if (entityType == EntityType.USER) {
            builder.append("select ? as type, u.*");
            arguments.add(EntityType.USER.toString().toLowerCase());
            if ((joinPlan & 2) != 0) {
                builder.append(", g.name as parent_group_name");
            }
            builder.append(" from _User u ");
        }
    }

    private void generateJoinClauses(StringBuilder builder, EntityType entityType, int joinPlan) {
        if (entityType == EntityType.GROUP) {
            if ((joinPlan & 1) != 0) {
                if (this.flattening) {
                    if (this.useMaterializedViews) {
                        builder.append("left outer join _Group_Membership_Transitive mp ");
                    } else {
                        builder.append("left outer join _Group_Membership_Transitive_Non_Materialized mp ");
                    }
                } else {
                    builder.append("left outer join _Group_Membership mp ");
                }
                builder.append("on mp.member_group_id = g.id ");
                builder.append("left outer join _Group gp on gp.id = mp.parent_group_id ");
            }
            if ((joinPlan & 4) != 0) {
                if (this.flattening) {
                    if (this.useMaterializedViews) {
                        builder.append("left outer join _Group_Membership_Transitive mc ");
                    } else {
                        builder.append("left outer join _Group_Membership_Transitive_Non_Materialized mc ");
                    }
                } else {
                    builder.append("left outer join _Group_Membership mc ");
                }
                builder.append("on mc.parent_group_id = g.id ");
                builder.append("left outer join _Group gc on gc.id = mc.member_group_id ");
            }
            if ((joinPlan & 8) != 0) {
                if (this.flattening) {
                    if (this.useMaterializedViews) {
                        builder.append("left outer join _User_Membership_Transitive mu ");
                    } else {
                        builder.append("left outer join _User_Membership_Transitive_Non_Materialized mu ");
                    }
                } else {
                    builder.append("left outer join _User_Membership mu ");
                }
                builder.append("on mu.parent_group_id = g.id ");
                builder.append("left outer join _User u on u.id = mu.member_user_id ");
            }
        } else if (entityType == EntityType.USER && (joinPlan & 2) != 0) {
            if (this.flattening) {
                if (this.useMaterializedViews) {
                    builder.append("left outer join _User_Membership_Transitive mu ");
                } else {
                    builder.append("left outer join _User_Membership_Transitive_Non_Materialized mu ");
                }
            } else {
                builder.append("left outer join _User_Membership mu ");
            }
            builder.append("on mu.member_user_id = u.id ");
            builder.append("left outer join _Group g on g.id = mu.parent_group_id ");
        }
    }

    private void generateWhereClause(StringBuilder builder, EntityType entityType, int joinPlan, QueryExpression expression, List<Object> arguments) {
        builder.append("where ");
        if ((joinPlan & 0xA) != 0) {
            builder.append("( ");
        }
        this.transformQueryExpressionToSql(builder, entityType, joinPlan, expression, arguments);
        if ((joinPlan & 0xA) != 0) {
            builder.append(") and ( u.active is null or u.active or ? = 'false' ) ");
            arguments.add(this.activeUsersOnly);
        }
    }

    private void generateOrderByClause(StringBuilder builder, EntityType entityType) {
        if (entityType == EntityType.GROUP) {
            builder.append("order by g.id");
        } else if (entityType == EntityType.USER) {
            builder.append("order by u.id");
        }
    }

    private void transformQueryExpressionToSql(StringBuilder builder, EntityType entityType, int joinPlan, QueryExpression expression, List<Object> arguments) {
        if (expression instanceof BooleanValue) {
            builder.append("? = 'true' ");
            arguments.add(((BooleanValue)expression).getValue());
        } else if (expression instanceof AndLogicExpression) {
            Iterator<QueryExpression> iter = ((AndLogicExpression)expression).getChildren().iterator();
            if (!iter.hasNext()) {
                builder.append("? = 'true' ");
                arguments.add(AndLogicExpression.EMPTY_SEQ_BOOLEAN);
            } else {
                QueryExpression first = iter.next();
                if (!iter.hasNext()) {
                    this.transformQueryExpressionToSql(builder, entityType, joinPlan, first, arguments);
                } else {
                    builder.append("( ");
                    this.transformQueryExpressionToSql(builder, entityType, joinPlan, first, arguments);
                    while (iter.hasNext()) {
                        builder.append(" and ");
                        this.transformQueryExpressionToSql(builder, entityType, joinPlan, iter.next(), arguments);
                    }
                    builder.append(") ");
                }
            }
        } else if (expression instanceof OrLogicExpression) {
            Iterator<QueryExpression> iter = ((OrLogicExpression)expression).getChildren().iterator();
            if (!iter.hasNext()) {
                builder.append("? = 'true' ");
                arguments.add(OrLogicExpression.EMPTY_SEQ_BOOLEAN);
            } else {
                QueryExpression first = iter.next();
                if (!iter.hasNext()) {
                    this.transformQueryExpressionToSql(builder, entityType, joinPlan, first, arguments);
                } else {
                    builder.append("( ");
                    this.transformQueryExpressionToSql(builder, entityType, joinPlan, first, arguments);
                    while (iter.hasNext()) {
                        builder.append(" or ");
                        this.transformQueryExpressionToSql(builder, entityType, joinPlan, iter.next(), arguments);
                    }
                    builder.append(") ");
                }
            }
        } else if (expression instanceof NotLogicExpression) {
            Iterator<QueryExpression> iter = ((NotLogicExpression)expression).getChildren().iterator();
            if (!iter.hasNext()) {
                builder.append("? = 'true' ");
                arguments.add(NotLogicExpression.EMPTY_SEQ_BOOLEAN);
            } else {
                QueryExpression first = iter.next();
                if (!iter.hasNext()) {
                    builder.append("not ");
                    this.transformQueryExpressionToSql(builder, entityType, joinPlan, first, arguments);
                } else {
                    builder.append("not ( ");
                    this.transformQueryExpressionToSql(builder, entityType, joinPlan, first, arguments);
                    while (iter.hasNext()) {
                        builder.append(" or ");
                        this.transformQueryExpressionToSql(builder, entityType, joinPlan, iter.next(), arguments);
                    }
                    builder.append(") ");
                }
            }
        } else if (expression instanceof OperatorExpression) {
            this.processOperator(builder, arguments, entityType, joinPlan, (OperatorExpression)expression);
        } else {
            throw new IllegalArgumentException("Cannot process unexpected query expression " + expression.getClass().getName());
        }
    }

    private void processOperator(StringBuilder builder, List<Object> arguments, EntityType entityType, int joinPlan, OperatorExpression expression) {
        switch (LdapUtils.normalizeAttribute(expression.getAttribute())) {
            case "0.9.2342.19200300.100.1.1": {
                if (entityType != EntityType.USER) break;
                builder.append("u.id ");
                this.handleOperator(builder, arguments, expression);
                break;
            }
            case "2.5.4.3": {
                if (entityType == EntityType.GROUP) {
                    builder.append("lower(g.name) ");
                    this.handleOperator(builder, arguments, expression);
                    break;
                }
                if (entityType != EntityType.USER) break;
                builder.append("lower(u.username) ");
                this.handleOperator(builder, arguments, expression);
                break;
            }
            case "2.5.4.4": {
                if (entityType != EntityType.USER) break;
                builder.append("lower(u.last_name) ");
                this.handleOperator(builder, arguments, expression);
                break;
            }
            case "2.5.4.42": {
                if (entityType != EntityType.USER) break;
                builder.append("lower(u.first_name) ");
                this.handleOperator(builder, arguments, expression);
                break;
            }
            case "2.16.840.1.113730.3.1.241": {
                if (entityType != EntityType.USER) break;
                builder.append("lower(u.display_name) ");
                this.handleOperator(builder, arguments, expression);
                break;
            }
            case "0.9.2342.19200300.100.1.3": {
                if (entityType != EntityType.USER) break;
                builder.append("lower(u.email) ");
                this.handleOperator(builder, arguments, expression);
                break;
            }
            case "2.5.4.13": {
                if (entityType != EntityType.GROUP) break;
                builder.append("lower(g.description) ");
                this.handleOperator(builder, arguments, expression);
                break;
            }
            case "2.5.4.31": 
            case "2.5.4.50": {
                if (entityType != EntityType.GROUP) break;
                if (expression instanceof EqualOperator) {
                    String groupId = null;
                    String userId = null;
                    if ((joinPlan & 4) != 0) {
                        groupId = LdapUtils.getGroupIdFromDn(this.schemaManager, ((EqualOperator)expression).getValue(), this.dcId);
                    }
                    if ((joinPlan & 8) != 0) {
                        userId = LdapUtils.getUserIdFromDn(this.schemaManager, ((EqualOperator)expression).getValue(), this.dcId);
                    }
                    if (groupId != null) {
                        if (expression.isNegated()) {
                            builder.append("g.id not in ( select parent_group_id ");
                        } else {
                            builder.append("g.id in ( select parent_group_id ");
                        }
                        if (this.flattening) {
                            if (this.useMaterializedViews) {
                                builder.append("from _Group_Membership_Transitive ");
                            } else {
                                builder.append("from _Group_Membership_Transitive_Non_Materialized ");
                            }
                        } else {
                            builder.append("from _Group_Membership ");
                        }
                        builder.append("where member_group_id = ? ");
                        arguments.add(groupId.toLowerCase());
                        builder.append(") ");
                    }
                    if (userId != null) {
                        if (expression.isNegated()) {
                            builder.append("g.id not in ( select parent_group_id ");
                        } else {
                            builder.append("g.id in ( select parent_group_id ");
                        }
                        if (this.flattening) {
                            if (this.useMaterializedViews) {
                                builder.append("from _User_Membership_Transitive ");
                            } else {
                                builder.append("from _User_Membership_Transitive_Non_Materialized ");
                            }
                        } else {
                            builder.append("from _User_Membership ");
                        }
                        builder.append("where member_user_id = ? ");
                        arguments.add(userId.toLowerCase());
                        builder.append(") ");
                    }
                    if (groupId != null || userId != null) break;
                    builder.append("? = 'true' ");
                    arguments.add(false);
                    break;
                }
                if (!(expression instanceof PresenceOperator)) break;
                if (expression.isNegated()) {
                    builder.append("( mc.member_group_id is null and mu.member_user_id is null ) ");
                    break;
                }
                builder.append("( mc.member_group_id is not null or mu.member_user_id is not null ) ");
                break;
            }
            case "1.2.840.113556.1.2.102": {
                if (entityType == EntityType.GROUP) {
                    if (expression instanceof EqualOperator) {
                        String groupId = null;
                        if ((joinPlan & 1) != 0) {
                            groupId = LdapUtils.getGroupIdFromDn(this.schemaManager, ((EqualOperator)expression).getValue(), this.dcId);
                        }
                        if (groupId == null) {
                            builder.append("? = 'true' ");
                            arguments.add(false);
                            break;
                        }
                        if (expression.isNegated()) {
                            builder.append("g.id not in ( select member_group_id ");
                        } else {
                            builder.append("g.id in ( select member_group_id ");
                        }
                        if (this.flattening) {
                            if (this.useMaterializedViews) {
                                builder.append("from _Group_Membership_Transitive ");
                            } else {
                                builder.append("from _Group_Membership_Transitive_Non_Materialized ");
                            }
                        } else {
                            builder.append("from _Group_Membership ");
                        }
                        builder.append("where parent_group_id = ? ");
                        arguments.add(groupId.toLowerCase());
                        builder.append(") ");
                        break;
                    }
                    if (!(expression instanceof PresenceOperator)) break;
                    builder.append("mp.parent_group_id ");
                    builder.append(this.getOperator(expression));
                    break;
                }
                if (entityType != EntityType.USER) break;
                if (expression instanceof EqualOperator) {
                    String groupId = null;
                    if ((joinPlan & 2) != 0) {
                        groupId = LdapUtils.getGroupIdFromDn(this.schemaManager, ((EqualOperator)expression).getValue(), this.dcId);
                    }
                    if (groupId == null) {
                        builder.append("? = 'true' ");
                        arguments.add(false);
                        break;
                    }
                    if (expression.isNegated()) {
                        builder.append("u.id not in ( select member_user_id ");
                    } else {
                        builder.append("u.id in ( select member_user_id ");
                    }
                    if (this.flattening) {
                        if (this.useMaterializedViews) {
                            builder.append("from _User_Membership_Transitive ");
                        } else {
                            builder.append("from _User_Membership_Transitive_Non_Materialized ");
                        }
                    } else {
                        builder.append("from _User_Membership ");
                    }
                    builder.append("where parent_group_id = ? ");
                    arguments.add(groupId.toLowerCase());
                    builder.append(") ");
                    break;
                }
                if (!(expression instanceof PresenceOperator)) break;
                builder.append("mu.parent_group_id ");
                builder.append(this.getOperator(expression));
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot process unexpected query expression " + expression.getClass().getName());
            }
        }
    }

    private void handleOperator(StringBuilder builder, List<Object> arguments, OperatorExpression expression) {
        builder.append(this.getOperator(expression));
        if (expression instanceof BinaryOperator) {
            builder.append("? ");
            if (expression instanceof WildcardOperator) {
                arguments.add(((WildcardOperator)expression).getValue(WildcardOperator.Format.SQL));
            } else {
                arguments.add(((BinaryOperator)expression).getValue().toLowerCase());
            }
        }
    }

    private String getOperator(OperatorExpression expression) {
        if (expression instanceof EqualOperator) {
            if (expression.isNegated()) {
                return "<> ";
            }
            return "= ";
        }
        if (expression instanceof WildcardOperator) {
            if (expression.isNegated()) {
                return "not like ";
            }
            return "like ";
        }
        if (expression instanceof PresenceOperator) {
            if (expression.isNegated()) {
                return "is null ";
            }
            return "is not null ";
        }
        throw new IllegalArgumentException("Cannot handle unexpected operator " + expression.getClass().getSimpleName());
    }
}

