/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;

public class NearImageArgument
implements Argument {
    private final String image;
    private final File imageFile;
    private final Float certainty;

    private String readFile(File file) {
        try {
            byte[] content = Files.readAllBytes(Paths.get(file.toURI()));
            String base64encodedFile = Base64.getEncoder().encodeToString(content);
            return String.format("data:image/png;base64,%s", base64encodedFile);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getContent() {
        if (StringUtils.isNotBlank((CharSequence)this.image)) {
            return this.image;
        }
        if (this.imageFile != null) {
            return this.readFile(this.imageFile);
        }
        return null;
    }

    @Override
    public String build() {
        String content = this.getContent();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            LinkedHashSet<String> fields = new LinkedHashSet<String>();
            fields.add(String.format("image: \"%s\"", content));
            if (this.certainty != null) {
                fields.add(String.format("certainty: %s", this.certainty));
            }
            return String.format("nearImage: {%s}", StringUtils.joinWith((String)" ", (Object[])fields.toArray()));
        }
        return "";
    }

    NearImageArgument(String image, File imageFile, Float certainty) {
        this.image = image;
        this.imageFile = imageFile;
        this.certainty = certainty;
    }

    public static NearImageArgumentBuilder builder() {
        return new NearImageArgumentBuilder();
    }

    public String getImage() {
        return this.image;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public static class NearImageArgumentBuilder {
        private String image;
        private File imageFile;
        private Float certainty;

        NearImageArgumentBuilder() {
        }

        public NearImageArgumentBuilder image(String image) {
            this.image = image;
            return this;
        }

        public NearImageArgumentBuilder imageFile(File imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        public NearImageArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearImageArgument build() {
            return new NearImageArgument(this.image, this.imageFile, this.certainty);
        }

        public String toString() {
            return "NearImageArgument.NearImageArgumentBuilder(image=" + this.image + ", imageFile=" + this.imageFile + ", certainty=" + this.certainty + ")";
        }
    }
}

