// Generated by delombok at Tue Aug 10 20:07:00 UTC 2021
package technology.semi.weaviate.client.v1.graphql.query.builder;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.AskArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;

public class GetBuilder implements Query {
  private final String className;
  private final String fields;
  private final String withWhereFilter;
  private final Integer limit;
  private final NearTextArgument withNearTextFilter;
  private final NearObjectArgument withNearObjectFilter;
  private final AskArgument withAskArgument;
  private final NearImageArgument withNearImageFilter;
  private final Float[] withNearVectorFilter;
  private final String withGroupFilter;

  private boolean includesFilterClause() {
    return StringUtils.isNotBlank(withWhereFilter) || withNearTextFilter != null || withNearObjectFilter != null || (withNearVectorFilter != null && withNearVectorFilter.length > 0) || StringUtils.isNotBlank(withGroupFilter) || withAskArgument != null || withNearImageFilter != null || limit != null;
  }

  private String createFilterClause() {
    if (includesFilterClause()) {
      Set<String> filters = new LinkedHashSet<>();
      if (StringUtils.isNotBlank(withWhereFilter)) {
        filters.add(String.format("where: %s", withWhereFilter));
      }
      if (withNearTextFilter != null) {
        filters.add(withNearTextFilter.build());
      }
      if (withNearObjectFilter != null) {
        filters.add(withNearObjectFilter.build());
      }
      if (withNearVectorFilter != null && withNearVectorFilter.length > 0) {
        filters.add(String.format("nearVector: {vector: [%s]}", StringUtils.joinWith(",", (Object[]) withNearVectorFilter)));
      }
      if (StringUtils.isNotBlank(withGroupFilter)) {
        filters.add(String.format("group: %s", withGroupFilter));
      }
      if (withAskArgument != null) {
        filters.add(withAskArgument.build());
      }
      if (withNearImageFilter != null) {
        filters.add(withNearImageFilter.build());
      }
      if (limit != null) {
        filters.add(String.format("limit: %s", limit));
      }
      return String.format("(%s)", StringUtils.joinWith(", ", filters.toArray()));
    }
    return "";
  }

  @Override
  public String buildQuery() {
    return String.format("{Get{%s%s{%s}}}", className, createFilterClause(), fields);
  }

  @java.lang.SuppressWarnings("all")
  GetBuilder(final String className, final String fields, final String withWhereFilter, final Integer limit, final NearTextArgument withNearTextFilter, final NearObjectArgument withNearObjectFilter, final AskArgument withAskArgument, final NearImageArgument withNearImageFilter, final Float[] withNearVectorFilter, final String withGroupFilter) {
    this.className = className;
    this.fields = fields;
    this.withWhereFilter = withWhereFilter;
    this.limit = limit;
    this.withNearTextFilter = withNearTextFilter;
    this.withNearObjectFilter = withNearObjectFilter;
    this.withAskArgument = withAskArgument;
    this.withNearImageFilter = withNearImageFilter;
    this.withNearVectorFilter = withNearVectorFilter;
    this.withGroupFilter = withGroupFilter;
  }


  @java.lang.SuppressWarnings("all")
  public static class GetBuilderBuilder {
    @java.lang.SuppressWarnings("all")
    private String className;
    @java.lang.SuppressWarnings("all")
    private String fields;
    @java.lang.SuppressWarnings("all")
    private String withWhereFilter;
    @java.lang.SuppressWarnings("all")
    private Integer limit;
    @java.lang.SuppressWarnings("all")
    private NearTextArgument withNearTextFilter;
    @java.lang.SuppressWarnings("all")
    private NearObjectArgument withNearObjectFilter;
    @java.lang.SuppressWarnings("all")
    private AskArgument withAskArgument;
    @java.lang.SuppressWarnings("all")
    private NearImageArgument withNearImageFilter;
    @java.lang.SuppressWarnings("all")
    private Float[] withNearVectorFilter;
    @java.lang.SuppressWarnings("all")
    private String withGroupFilter;

    @java.lang.SuppressWarnings("all")
    GetBuilderBuilder() {
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder className(final String className) {
      this.className = className;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder fields(final String fields) {
      this.fields = fields;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withWhereFilter(final String withWhereFilter) {
      this.withWhereFilter = withWhereFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder limit(final Integer limit) {
      this.limit = limit;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearTextFilter(final NearTextArgument withNearTextFilter) {
      this.withNearTextFilter = withNearTextFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearObjectFilter(final NearObjectArgument withNearObjectFilter) {
      this.withNearObjectFilter = withNearObjectFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withAskArgument(final AskArgument withAskArgument) {
      this.withAskArgument = withAskArgument;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearImageFilter(final NearImageArgument withNearImageFilter) {
      this.withNearImageFilter = withNearImageFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearVectorFilter(final Float[] withNearVectorFilter) {
      this.withNearVectorFilter = withNearVectorFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withGroupFilter(final String withGroupFilter) {
      this.withGroupFilter = withGroupFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder build() {
      return new GetBuilder(this.className, this.fields, this.withWhereFilter, this.limit, this.withNearTextFilter, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter, this.withGroupFilter);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "GetBuilder.GetBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", withWhereFilter=" + this.withWhereFilter + ", limit=" + this.limit + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + java.util.Arrays.deepToString(this.withNearVectorFilter) + ", withGroupFilter=" + this.withGroupFilter + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static GetBuilder.GetBuilderBuilder builder() {
    return new GetBuilder.GetBuilderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getClassName() {
    return this.className;
  }

  @java.lang.SuppressWarnings("all")
  public String getFields() {
    return this.fields;
  }

  @java.lang.SuppressWarnings("all")
  public String getWithWhereFilter() {
    return this.withWhereFilter;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getLimit() {
    return this.limit;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextArgument getWithNearTextFilter() {
    return this.withNearTextFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearObjectArgument getWithNearObjectFilter() {
    return this.withNearObjectFilter;
  }

  @java.lang.SuppressWarnings("all")
  public AskArgument getWithAskArgument() {
    return this.withAskArgument;
  }

  @java.lang.SuppressWarnings("all")
  public NearImageArgument getWithNearImageFilter() {
    return this.withNearImageFilter;
  }

  @java.lang.SuppressWarnings("all")
  public Float[] getWithNearVectorFilter() {
    return this.withNearVectorFilter;
  }

  @java.lang.SuppressWarnings("all")
  public String getWithGroupFilter() {
    return this.withGroupFilter;
  }
}
