/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.builder;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.AskArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import technology.semi.weaviate.client.v1.graphql.query.builder.Query;

public class GetBuilder
implements Query {
    private final String className;
    private final String fields;
    private final String withWhereFilter;
    private final Integer limit;
    private final NearTextArgument withNearTextFilter;
    private final NearObjectArgument withNearObjectFilter;
    private final AskArgument withAskArgument;
    private final NearImageArgument withNearImageFilter;
    private final Float[] withNearVectorFilter;
    private final String withGroupFilter;

    private boolean includesFilterClause() {
        return StringUtils.isNotBlank((CharSequence)this.withWhereFilter) || this.withNearTextFilter != null || this.withNearObjectFilter != null || this.withNearVectorFilter != null && this.withNearVectorFilter.length > 0 || StringUtils.isNotBlank((CharSequence)this.withGroupFilter) || this.withAskArgument != null || this.withNearImageFilter != null || this.limit != null;
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)this.withWhereFilter)) {
                filters.add(String.format("where: %s", this.withWhereFilter));
            }
            if (this.withNearTextFilter != null) {
                filters.add(this.withNearTextFilter.build());
            }
            if (this.withNearObjectFilter != null) {
                filters.add(this.withNearObjectFilter.build());
            }
            if (this.withNearVectorFilter != null && this.withNearVectorFilter.length > 0) {
                filters.add(String.format("nearVector: {vector: [%s]}", StringUtils.joinWith((String)",", (Object[])this.withNearVectorFilter)));
            }
            if (StringUtils.isNotBlank((CharSequence)this.withGroupFilter)) {
                filters.add(String.format("group: %s", this.withGroupFilter));
            }
            if (this.withAskArgument != null) {
                filters.add(this.withAskArgument.build());
            }
            if (this.withNearImageFilter != null) {
                filters.add(this.withNearImageFilter.build());
            }
            if (this.limit != null) {
                filters.add(String.format("limit: %s", this.limit));
            }
            return String.format("(%s)", StringUtils.joinWith((String)", ", (Object[])filters.toArray()));
        }
        return "";
    }

    @Override
    public String buildQuery() {
        return String.format("{Get{%s%s{%s}}}", this.className, this.createFilterClause(), this.fields);
    }

    GetBuilder(String className, String fields, String withWhereFilter, Integer limit, NearTextArgument withNearTextFilter, NearObjectArgument withNearObjectFilter, AskArgument withAskArgument, NearImageArgument withNearImageFilter, Float[] withNearVectorFilter, String withGroupFilter) {
        this.className = className;
        this.fields = fields;
        this.withWhereFilter = withWhereFilter;
        this.limit = limit;
        this.withNearTextFilter = withNearTextFilter;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withAskArgument = withAskArgument;
        this.withNearImageFilter = withNearImageFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withGroupFilter = withGroupFilter;
    }

    public static GetBuilderBuilder builder() {
        return new GetBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFields() {
        return this.fields;
    }

    public String getWithWhereFilter() {
        return this.withWhereFilter;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public NearTextArgument getWithNearTextFilter() {
        return this.withNearTextFilter;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public Float[] getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public String getWithGroupFilter() {
        return this.withGroupFilter;
    }

    public static class GetBuilderBuilder {
        private String className;
        private String fields;
        private String withWhereFilter;
        private Integer limit;
        private NearTextArgument withNearTextFilter;
        private NearObjectArgument withNearObjectFilter;
        private AskArgument withAskArgument;
        private NearImageArgument withNearImageFilter;
        private Float[] withNearVectorFilter;
        private String withGroupFilter;

        GetBuilderBuilder() {
        }

        public GetBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public GetBuilderBuilder fields(String fields) {
            this.fields = fields;
            return this;
        }

        public GetBuilderBuilder withWhereFilter(String withWhereFilter) {
            this.withWhereFilter = withWhereFilter;
            return this;
        }

        public GetBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetBuilderBuilder withNearTextFilter(NearTextArgument withNearTextFilter) {
            this.withNearTextFilter = withNearTextFilter;
            return this;
        }

        public GetBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public GetBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public GetBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public GetBuilderBuilder withNearVectorFilter(Float[] withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public GetBuilderBuilder withGroupFilter(String withGroupFilter) {
            this.withGroupFilter = withGroupFilter;
            return this;
        }

        public GetBuilder build() {
            return new GetBuilder(this.className, this.fields, this.withWhereFilter, this.limit, this.withNearTextFilter, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter, this.withGroupFilter);
        }

        public String toString() {
            return "GetBuilder.GetBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", withWhereFilter=" + this.withWhereFilter + ", limit=" + this.limit + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + Arrays.deepToString(this.withNearVectorFilter) + ", withGroupFilter=" + this.withGroupFilter + ")";
        }
    }
}

