/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.classifications.api;

import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.BaseClient;
import technology.semi.weaviate.client.base.ClientResult;
import technology.semi.weaviate.client.base.Response;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.v1.classifications.api.Getter;
import technology.semi.weaviate.client.v1.classifications.model.Classification;
import technology.semi.weaviate.client.v1.classifications.model.ClassificationFilters;
import technology.semi.weaviate.client.v1.classifications.model.WhereFilter;

public class Scheduler
extends BaseClient<Classification>
implements ClientResult<Classification> {
    private String classificationType;
    private String className;
    private String[] classifyProperties;
    private String[] basedOnProperties;
    private WhereFilter sourceWhereFilter;
    private WhereFilter trainingSetWhereFilter;
    private WhereFilter targetWhereFilter;
    private Boolean waitForCompletion;
    private Object settings;
    private Getter getter;

    public Scheduler(Config config) {
        super(config);
        this.getter = new Getter(config);
        this.waitForCompletion = false;
    }

    public Scheduler withType(String classificationType) {
        this.classificationType = classificationType;
        return this;
    }

    public Scheduler withClassName(String className) {
        this.className = className;
        return this;
    }

    public Scheduler withClassifyProperties(String[] classifyProperties) {
        this.classifyProperties = classifyProperties;
        return this;
    }

    public Scheduler withBasedOnProperties(String[] basedOnProperties) {
        this.basedOnProperties = basedOnProperties;
        return this;
    }

    public Scheduler withSourceWhereFilter(WhereFilter whereFilter) {
        this.sourceWhereFilter = whereFilter;
        return this;
    }

    public Scheduler withTrainingSetWhereFilter(WhereFilter whereFilter) {
        this.trainingSetWhereFilter = whereFilter;
        return this;
    }

    public Scheduler withTargetWhereFilter(WhereFilter whereFilter) {
        this.targetWhereFilter = whereFilter;
        return this;
    }

    public Scheduler withSettings(Object settings) {
        this.settings = settings;
        return this;
    }

    public Scheduler withWaitForCompletion() {
        this.waitForCompletion = true;
        return this;
    }

    private Classification waitForCompletion(String id) throws InterruptedException {
        Classification runningClassification;
        while (true) {
            Result<Classification> result;
            if ((result = this.getter.withID(id).run()) == null || result.getResult() == null) {
                return null;
            }
            runningClassification = result.getResult();
            if (runningClassification.getStatus() != "running") break;
            Thread.sleep(2000L);
        }
        return runningClassification;
    }

    @Override
    public Result<Classification> run() {
        Classification config = Classification.builder().basedOnProperties(this.basedOnProperties).className(this.className).classifyProperties(this.classifyProperties).filters(ClassificationFilters.builder().sourceWhere(this.sourceWhereFilter).targetWhere(this.targetWhereFilter).trainingSetWhere(this.trainingSetWhereFilter).build()).type(this.classificationType).settings(this.settings).build();
        Response<Classification> resp = this.sendPostRequest("/classifications", config, Classification.class);
        if (resp.getStatusCode() == 201) {
            if (this.waitForCompletion.booleanValue()) {
                try {
                    Classification c = this.waitForCompletion(resp.getBody().getId());
                    return new Result<Classification>(resp.getStatusCode(), c, null);
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            return new Result<Classification>(resp);
        }
        return null;
    }
}

