// Generated by delombok at Tue Feb 01 18:55:47 UTC 2022
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class WhereFilter implements Argument {
  public final WhereOperator operator;
  public final String[] path;
  public final Integer valueInt;
  public final Double valueNumber;
  public final Boolean valueBoolean;
  public final String valueString;
  public final String valueText;
  public final Date valueDate;
  public final GeoCoordinatesParameter valueGeoRange;

  private String getArg(String name, Object value) {
    return String.format("%s:%s", name, value);
  }

  public String buildWhereFilter() {
    Set<String> arg = new LinkedHashSet<>();
    if (operator != null) {
      arg.add(getArg("operator", operator));
    }
    if (path != null && path.length > 0) {
      arg.add(String.format("path:[%s]", StringUtils.joinWith(",", Arrays.stream(path).map(s -> String.format("\"%s\"", s)).toArray())));
    }
    if (valueInt != null) {
      arg.add(getArg("valueInt", valueInt));
    }
    if (valueNumber != null) {
      arg.add(getArg("valueNumber", valueNumber));
    }
    if (valueBoolean != null) {
      arg.add(getArg("valueBoolean", valueBoolean));
    }
    if (valueString != null) {
      arg.add(getArg("valueString", String.format("\"%s\"", valueString)));
    }
    if (valueText != null) {
      arg.add(getArg("valueText", String.format("\"%s\"", valueText)));
    }
    if (valueDate != null) {
      arg.add(getArg("valueDate", DateFormatUtils.format(valueDate, "yyyy-MM-dd\'T\'HH:mm:ssZZZZZ")));
    }
    if (valueGeoRange != null) {
      arg.add(getArg("valueGeoRange", valueGeoRange.build()));
    }
    if (arg.size() > 0) {
      return String.format("%s", StringUtils.joinWith(" ", arg.toArray()));
    }
    return "";
  }

  @Override
  public String build() {
    return buildWhereFilter();
  }

  @java.lang.SuppressWarnings("all")
  WhereFilter(final WhereOperator operator, final String[] path, final Integer valueInt, final Double valueNumber, final Boolean valueBoolean, final String valueString, final String valueText, final Date valueDate, final GeoCoordinatesParameter valueGeoRange) {
    this.operator = operator;
    this.path = path;
    this.valueInt = valueInt;
    this.valueNumber = valueNumber;
    this.valueBoolean = valueBoolean;
    this.valueString = valueString;
    this.valueText = valueText;
    this.valueDate = valueDate;
    this.valueGeoRange = valueGeoRange;
  }


  @java.lang.SuppressWarnings("all")
  public static class WhereFilterBuilder {
    @java.lang.SuppressWarnings("all")
    private WhereOperator operator;
    @java.lang.SuppressWarnings("all")
    private String[] path;
    @java.lang.SuppressWarnings("all")
    private Integer valueInt;
    @java.lang.SuppressWarnings("all")
    private Double valueNumber;
    @java.lang.SuppressWarnings("all")
    private Boolean valueBoolean;
    @java.lang.SuppressWarnings("all")
    private String valueString;
    @java.lang.SuppressWarnings("all")
    private String valueText;
    @java.lang.SuppressWarnings("all")
    private Date valueDate;
    @java.lang.SuppressWarnings("all")
    private GeoCoordinatesParameter valueGeoRange;

    @java.lang.SuppressWarnings("all")
    WhereFilterBuilder() {
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter.WhereFilterBuilder operator(final WhereOperator operator) {
      this.operator = operator;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter.WhereFilterBuilder path(final String[] path) {
      this.path = path;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter.WhereFilterBuilder valueInt(final Integer valueInt) {
      this.valueInt = valueInt;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter.WhereFilterBuilder valueNumber(final Double valueNumber) {
      this.valueNumber = valueNumber;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter.WhereFilterBuilder valueBoolean(final Boolean valueBoolean) {
      this.valueBoolean = valueBoolean;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter.WhereFilterBuilder valueString(final String valueString) {
      this.valueString = valueString;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter.WhereFilterBuilder valueText(final String valueText) {
      this.valueText = valueText;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter.WhereFilterBuilder valueDate(final Date valueDate) {
      this.valueDate = valueDate;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter.WhereFilterBuilder valueGeoRange(final GeoCoordinatesParameter valueGeoRange) {
      this.valueGeoRange = valueGeoRange;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter build() {
      return new WhereFilter(this.operator, this.path, this.valueInt, this.valueNumber, this.valueBoolean, this.valueString, this.valueText, this.valueDate, this.valueGeoRange);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "WhereFilter.WhereFilterBuilder(operator=" + this.operator + ", path=" + java.util.Arrays.deepToString(this.path) + ", valueInt=" + this.valueInt + ", valueNumber=" + this.valueNumber + ", valueBoolean=" + this.valueBoolean + ", valueString=" + this.valueString + ", valueText=" + this.valueText + ", valueDate=" + this.valueDate + ", valueGeoRange=" + this.valueGeoRange + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static WhereFilter.WhereFilterBuilder builder() {
    return new WhereFilter.WhereFilterBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public WhereOperator getOperator() {
    return this.operator;
  }

  @java.lang.SuppressWarnings("all")
  public String[] getPath() {
    return this.path;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getValueInt() {
    return this.valueInt;
  }

  @java.lang.SuppressWarnings("all")
  public Double getValueNumber() {
    return this.valueNumber;
  }

  @java.lang.SuppressWarnings("all")
  public Boolean getValueBoolean() {
    return this.valueBoolean;
  }

  @java.lang.SuppressWarnings("all")
  public String getValueString() {
    return this.valueString;
  }

  @java.lang.SuppressWarnings("all")
  public String getValueText() {
    return this.valueText;
  }

  @java.lang.SuppressWarnings("all")
  public Date getValueDate() {
    return this.valueDate;
  }

  @java.lang.SuppressWarnings("all")
  public GeoCoordinatesParameter getValueGeoRange() {
    return this.valueGeoRange;
  }
}
