// Generated by delombok at Fri Mar 11 12:44:08 UTC 2022
package technology.semi.weaviate.client.v1.graphql.query.builder;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.WhereArgument;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;

public class AggregateBuilder implements Query {
  private final String className;
  private final Fields fields;
  private final String groupByClausePropertyName;
  private final WhereArgument withWhereArgument;

  private boolean includesFilterClause() {
    return withWhereArgument != null || StringUtils.isNotBlank(groupByClausePropertyName);
  }

  private String createFilterClause() {
    if (includesFilterClause()) {
      Set<String> filters = new LinkedHashSet<>();
      if (StringUtils.isNotBlank(groupByClausePropertyName)) {
        filters.add(String.format("groupBy: \"%s\"", groupByClausePropertyName));
      }
      if (withWhereArgument != null) {
        filters.add(withWhereArgument.build());
      }
      return String.format("(%s)", StringUtils.joinWith(", ", filters.toArray()));
    }
    return "";
  }

  @Override
  public String buildQuery() {
    String fieldsClause = fields != null ? fields.build() : "";
    return String.format("{Aggregate{%s%s{%s}}}", className, createFilterClause(), fieldsClause);
  }

  @java.lang.SuppressWarnings("all")
  AggregateBuilder(final String className, final Fields fields, final String groupByClausePropertyName, final WhereArgument withWhereArgument) {
    this.className = className;
    this.fields = fields;
    this.groupByClausePropertyName = groupByClausePropertyName;
    this.withWhereArgument = withWhereArgument;
  }


  @java.lang.SuppressWarnings("all")
  public static class AggregateBuilderBuilder {
    @java.lang.SuppressWarnings("all")
    private String className;
    @java.lang.SuppressWarnings("all")
    private Fields fields;
    @java.lang.SuppressWarnings("all")
    private String groupByClausePropertyName;
    @java.lang.SuppressWarnings("all")
    private WhereArgument withWhereArgument;

    @java.lang.SuppressWarnings("all")
    AggregateBuilderBuilder() {
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder className(final String className) {
      this.className = className;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder fields(final Fields fields) {
      this.fields = fields;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder groupByClausePropertyName(final String groupByClausePropertyName) {
      this.groupByClausePropertyName = groupByClausePropertyName;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withWhereArgument(final WhereArgument withWhereArgument) {
      this.withWhereArgument = withWhereArgument;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder build() {
      return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName, this.withWhereArgument);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ", withWhereArgument=" + this.withWhereArgument + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static AggregateBuilder.AggregateBuilderBuilder builder() {
    return new AggregateBuilder.AggregateBuilderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getClassName() {
    return this.className;
  }

  @java.lang.SuppressWarnings("all")
  public Fields getFields() {
    return this.fields;
  }

  @java.lang.SuppressWarnings("all")
  public String getGroupByClausePropertyName() {
    return this.groupByClausePropertyName;
  }

  @java.lang.SuppressWarnings("all")
  public WhereArgument getWithWhereArgument() {
    return this.withWhereArgument;
  }
}
