/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;
import technology.semi.weaviate.client.v1.graphql.query.argument.GeoCoordinatesParameter;
import technology.semi.weaviate.client.v1.graphql.query.argument.WhereOperator;

public class WhereFilter
implements Argument {
    public final WhereOperator operator;
    public final String[] path;
    public final Integer valueInt;
    public final Double valueNumber;
    public final Boolean valueBoolean;
    public final String valueString;
    public final String valueText;
    public final Date valueDate;
    public final GeoCoordinatesParameter valueGeoRange;

    private String getArg(String name, Object value) {
        return String.format("%s:%s", name, value);
    }

    public String buildWhereFilter() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (this.operator != null) {
            arg.add(this.getArg("operator", (Object)this.operator));
        }
        if (this.path != null && this.path.length > 0) {
            arg.add(String.format("path:[%s]", StringUtils.joinWith((String)",", (Object[])Arrays.stream(this.path).map(s -> String.format("\"%s\"", s)).toArray())));
        }
        if (this.valueInt != null) {
            arg.add(this.getArg("valueInt", this.valueInt));
        }
        if (this.valueNumber != null) {
            arg.add(this.getArg("valueNumber", this.valueNumber));
        }
        if (this.valueBoolean != null) {
            arg.add(this.getArg("valueBoolean", this.valueBoolean));
        }
        if (this.valueString != null) {
            arg.add(this.getArg("valueString", String.format("\"%s\"", this.valueString)));
        }
        if (this.valueText != null) {
            arg.add(this.getArg("valueText", String.format("\"%s\"", this.valueText)));
        }
        if (this.valueDate != null) {
            arg.add(this.getArg("valueDate", DateFormatUtils.format((Date)this.valueDate, (String)"yyyy-MM-dd'T'HH:mm:ssZZZZZ")));
        }
        if (this.valueGeoRange != null) {
            arg.add(this.getArg("valueGeoRange", this.valueGeoRange.build()));
        }
        if (arg.size() > 0) {
            return String.format("%s", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
        }
        return "";
    }

    @Override
    public String build() {
        return this.buildWhereFilter();
    }

    WhereFilter(WhereOperator operator, String[] path, Integer valueInt, Double valueNumber, Boolean valueBoolean, String valueString, String valueText, Date valueDate, GeoCoordinatesParameter valueGeoRange) {
        this.operator = operator;
        this.path = path;
        this.valueInt = valueInt;
        this.valueNumber = valueNumber;
        this.valueBoolean = valueBoolean;
        this.valueString = valueString;
        this.valueText = valueText;
        this.valueDate = valueDate;
        this.valueGeoRange = valueGeoRange;
    }

    public static WhereFilterBuilder builder() {
        return new WhereFilterBuilder();
    }

    public WhereOperator getOperator() {
        return this.operator;
    }

    public String[] getPath() {
        return this.path;
    }

    public Integer getValueInt() {
        return this.valueInt;
    }

    public Double getValueNumber() {
        return this.valueNumber;
    }

    public Boolean getValueBoolean() {
        return this.valueBoolean;
    }

    public String getValueString() {
        return this.valueString;
    }

    public String getValueText() {
        return this.valueText;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public GeoCoordinatesParameter getValueGeoRange() {
        return this.valueGeoRange;
    }

    public static class WhereFilterBuilder {
        private WhereOperator operator;
        private String[] path;
        private Integer valueInt;
        private Double valueNumber;
        private Boolean valueBoolean;
        private String valueString;
        private String valueText;
        private Date valueDate;
        private GeoCoordinatesParameter valueGeoRange;

        WhereFilterBuilder() {
        }

        public WhereFilterBuilder operator(WhereOperator operator) {
            this.operator = operator;
            return this;
        }

        public WhereFilterBuilder path(String[] path) {
            this.path = path;
            return this;
        }

        public WhereFilterBuilder valueInt(Integer valueInt) {
            this.valueInt = valueInt;
            return this;
        }

        public WhereFilterBuilder valueNumber(Double valueNumber) {
            this.valueNumber = valueNumber;
            return this;
        }

        public WhereFilterBuilder valueBoolean(Boolean valueBoolean) {
            this.valueBoolean = valueBoolean;
            return this;
        }

        public WhereFilterBuilder valueString(String valueString) {
            this.valueString = valueString;
            return this;
        }

        public WhereFilterBuilder valueText(String valueText) {
            this.valueText = valueText;
            return this;
        }

        public WhereFilterBuilder valueDate(Date valueDate) {
            this.valueDate = valueDate;
            return this;
        }

        public WhereFilterBuilder valueGeoRange(GeoCoordinatesParameter valueGeoRange) {
            this.valueGeoRange = valueGeoRange;
            return this;
        }

        public WhereFilter build() {
            return new WhereFilter(this.operator, this.path, this.valueInt, this.valueNumber, this.valueBoolean, this.valueString, this.valueText, this.valueDate, this.valueGeoRange);
        }

        public String toString() {
            return "WhereFilter.WhereFilterBuilder(operator=" + (Object)((Object)this.operator) + ", path=" + Arrays.deepToString(this.path) + ", valueInt=" + this.valueInt + ", valueNumber=" + this.valueNumber + ", valueBoolean=" + this.valueBoolean + ", valueString=" + this.valueString + ", valueText=" + this.valueText + ", valueDate=" + this.valueDate + ", valueGeoRange=" + this.valueGeoRange + ")";
        }
    }
}

