/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.builder;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.WhereArgument;
import technology.semi.weaviate.client.v1.graphql.query.builder.Query;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;

public class AggregateBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final String groupByClausePropertyName;
    private final WhereArgument withWhereArgument;

    private boolean includesFilterClause() {
        return this.withWhereArgument != null || StringUtils.isNotBlank((CharSequence)this.groupByClausePropertyName);
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)this.groupByClausePropertyName)) {
                filters.add(String.format("groupBy: \"%s\"", this.groupByClausePropertyName));
            }
            if (this.withWhereArgument != null) {
                filters.add(this.withWhereArgument.build());
            }
            return String.format("(%s)", StringUtils.joinWith((String)", ", (Object[])filters.toArray()));
        }
        return "";
    }

    @Override
    public String buildQuery() {
        String fieldsClause = this.fields != null ? this.fields.build() : "";
        return String.format("{Aggregate{%s%s{%s}}}", this.className, this.createFilterClause(), fieldsClause);
    }

    AggregateBuilder(String className, Fields fields, String groupByClausePropertyName, WhereArgument withWhereArgument) {
        this.className = className;
        this.fields = fields;
        this.groupByClausePropertyName = groupByClausePropertyName;
        this.withWhereArgument = withWhereArgument;
    }

    public static AggregateBuilderBuilder builder() {
        return new AggregateBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public Fields getFields() {
        return this.fields;
    }

    public String getGroupByClausePropertyName() {
        return this.groupByClausePropertyName;
    }

    public WhereArgument getWithWhereArgument() {
        return this.withWhereArgument;
    }

    public static class AggregateBuilderBuilder {
        private String className;
        private Fields fields;
        private String groupByClausePropertyName;
        private WhereArgument withWhereArgument;

        AggregateBuilderBuilder() {
        }

        public AggregateBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public AggregateBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        public AggregateBuilderBuilder groupByClausePropertyName(String groupByClausePropertyName) {
            this.groupByClausePropertyName = groupByClausePropertyName;
            return this;
        }

        public AggregateBuilderBuilder withWhereArgument(WhereArgument withWhereArgument) {
            this.withWhereArgument = withWhereArgument;
            return this;
        }

        public AggregateBuilder build() {
            return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName, this.withWhereArgument);
        }

        public String toString() {
            return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ", withWhereArgument=" + this.withWhereArgument + ")";
        }
    }
}

