/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.builder;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.AskArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.GroupArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.WhereArgument;
import technology.semi.weaviate.client.v1.graphql.query.builder.Query;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;

public class GetBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final Integer offset;
    private final Integer limit;
    private final WhereArgument withWhereArgument;
    private final NearTextArgument withNearTextFilter;
    private final NearObjectArgument withNearObjectFilter;
    private final AskArgument withAskArgument;
    private final NearImageArgument withNearImageFilter;
    private final Float[] withNearVectorFilter;
    private final GroupArgument withGroupArgument;

    private boolean includesFilterClause() {
        return this.withWhereArgument != null || this.withNearTextFilter != null || this.withNearObjectFilter != null || this.withNearVectorFilter != null && this.withNearVectorFilter.length > 0 || this.withGroupArgument != null || this.withAskArgument != null || this.withNearImageFilter != null || this.limit != null;
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (this.withWhereArgument != null) {
                filters.add(this.withWhereArgument.build());
            }
            if (this.withNearTextFilter != null) {
                filters.add(this.withNearTextFilter.build());
            }
            if (this.withNearObjectFilter != null) {
                filters.add(this.withNearObjectFilter.build());
            }
            if (this.withNearVectorFilter != null && this.withNearVectorFilter.length > 0) {
                filters.add(String.format("nearVector: {vector: [%s]}", StringUtils.joinWith((String)",", (Object[])this.withNearVectorFilter)));
            }
            if (this.withGroupArgument != null) {
                filters.add(this.withGroupArgument.build());
            }
            if (this.withAskArgument != null) {
                filters.add(this.withAskArgument.build());
            }
            if (this.withNearImageFilter != null) {
                filters.add(this.withNearImageFilter.build());
            }
            if (this.limit != null) {
                filters.add(String.format("limit: %s", this.limit));
            }
            if (this.offset != null) {
                filters.add(String.format("offset: %s", this.offset));
            }
            return String.format("(%s)", StringUtils.joinWith((String)", ", (Object[])filters.toArray()));
        }
        return "";
    }

    private String createFields() {
        return this.fields != null ? this.fields.build() : "";
    }

    @Override
    public String buildQuery() {
        return String.format("{Get{%s%s{%s}}}", this.className, this.createFilterClause(), this.createFields());
    }

    GetBuilder(String className, Fields fields, Integer offset, Integer limit, WhereArgument withWhereArgument, NearTextArgument withNearTextFilter, NearObjectArgument withNearObjectFilter, AskArgument withAskArgument, NearImageArgument withNearImageFilter, Float[] withNearVectorFilter, GroupArgument withGroupArgument) {
        this.className = className;
        this.fields = fields;
        this.offset = offset;
        this.limit = limit;
        this.withWhereArgument = withWhereArgument;
        this.withNearTextFilter = withNearTextFilter;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withAskArgument = withAskArgument;
        this.withNearImageFilter = withNearImageFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withGroupArgument = withGroupArgument;
    }

    public static GetBuilderBuilder builder() {
        return new GetBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public Fields getFields() {
        return this.fields;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public WhereArgument getWithWhereArgument() {
        return this.withWhereArgument;
    }

    public NearTextArgument getWithNearTextFilter() {
        return this.withNearTextFilter;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public Float[] getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public GroupArgument getWithGroupArgument() {
        return this.withGroupArgument;
    }

    public static class GetBuilderBuilder {
        private String className;
        private Fields fields;
        private Integer offset;
        private Integer limit;
        private WhereArgument withWhereArgument;
        private NearTextArgument withNearTextFilter;
        private NearObjectArgument withNearObjectFilter;
        private AskArgument withAskArgument;
        private NearImageArgument withNearImageFilter;
        private Float[] withNearVectorFilter;
        private GroupArgument withGroupArgument;

        GetBuilderBuilder() {
        }

        public GetBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public GetBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        public GetBuilderBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetBuilderBuilder withWhereArgument(WhereArgument withWhereArgument) {
            this.withWhereArgument = withWhereArgument;
            return this;
        }

        public GetBuilderBuilder withNearTextFilter(NearTextArgument withNearTextFilter) {
            this.withNearTextFilter = withNearTextFilter;
            return this;
        }

        public GetBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public GetBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public GetBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public GetBuilderBuilder withNearVectorFilter(Float[] withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public GetBuilderBuilder withGroupArgument(GroupArgument withGroupArgument) {
            this.withGroupArgument = withGroupArgument;
            return this;
        }

        public GetBuilder build() {
            return new GetBuilder(this.className, this.fields, this.offset, this.limit, this.withWhereArgument, this.withNearTextFilter, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter, this.withGroupArgument);
        }

        public String toString() {
            return "GetBuilder.GetBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", offset=" + this.offset + ", limit=" + this.limit + ", withWhereArgument=" + this.withWhereArgument + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + Arrays.deepToString(this.withNearVectorFilter) + ", withGroupArgument=" + this.withGroupArgument + ")";
        }
    }
}

