/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.schema.api;

import java.util.List;
import java.util.stream.Collectors;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.base.WeaviateErrorMessage;
import technology.semi.weaviate.client.base.WeaviateErrorResponse;
import technology.semi.weaviate.client.v1.schema.api.ClassDeleter;
import technology.semi.weaviate.client.v1.schema.api.SchemaGetter;
import technology.semi.weaviate.client.v1.schema.model.Schema;
import technology.semi.weaviate.client.v1.schema.model.WeaviateClass;

public class SchemaDeleter {
    private SchemaGetter schemaGetter;
    private ClassDeleter classDeleter;

    public SchemaDeleter(SchemaGetter schemaGetter, ClassDeleter classDeleter) {
        this.schemaGetter = schemaGetter;
        this.classDeleter = classDeleter;
    }

    public Result<Boolean> run() {
        Result<Schema> schema = this.schemaGetter.run();
        if (schema.getError() != null) {
            List<WeaviateErrorMessage> errorMessages = schema.getError().getMessages().stream().map(err -> WeaviateErrorMessage.builder().message(err.getMessage()).build()).collect(Collectors.toList());
            WeaviateErrorResponse errors = WeaviateErrorResponse.builder().error(errorMessages).build();
            return new Result<Boolean>(schema.getError().getStatusCode(), false, errors);
        }
        if (schema.getError() == null) {
            List<WeaviateClass> weaviateClasses = schema.getResult().getClasses();
            for (WeaviateClass clazz : weaviateClasses) {
                Result<Boolean> result = this.classDeleter.withClassName(clazz.getClassName()).run();
                if (result.getError() == null) continue;
                return result;
            }
        }
        return new Result<Boolean>(200, true, null);
    }
}

