/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

public class GeoCoordinatesParameter {
    private final Float latitude;
    private final Float longitude;
    private final Float maxDistance;

    public String build() {
        if (this.latitude != null && this.longitude != null && this.maxDistance != null) {
            return String.format("{geoCoordinates:{latitude:%s,longitude:%s},distance:{max:%s}}", this.latitude, this.longitude, this.maxDistance);
        }
        return "";
    }

    GeoCoordinatesParameter(Float latitude, Float longitude, Float maxDistance) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.maxDistance = maxDistance;
    }

    public static GeoCoordinatesParameterBuilder builder() {
        return new GeoCoordinatesParameterBuilder();
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public Float getMaxDistance() {
        return this.maxDistance;
    }

    public static class GeoCoordinatesParameterBuilder {
        private Float latitude;
        private Float longitude;
        private Float maxDistance;

        GeoCoordinatesParameterBuilder() {
        }

        public GeoCoordinatesParameterBuilder latitude(Float latitude) {
            this.latitude = latitude;
            return this;
        }

        public GeoCoordinatesParameterBuilder longitude(Float longitude) {
            this.longitude = longitude;
            return this;
        }

        public GeoCoordinatesParameterBuilder maxDistance(Float maxDistance) {
            this.maxDistance = maxDistance;
            return this;
        }

        public GeoCoordinatesParameter build() {
            return new GeoCoordinatesParameter(this.latitude, this.longitude, this.maxDistance);
        }

        public String toString() {
            return "GeoCoordinatesParameter.GeoCoordinatesParameterBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ", maxDistance=" + this.maxDistance + ")";
        }
    }
}

