/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;
import technology.semi.weaviate.client.v1.graphql.query.argument.GroupType;

public class GroupArgument
implements Argument {
    private final GroupType type;
    private final Float force;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (this.type != null) {
            arg.add(String.format("type: %s", new Object[]{this.type}));
        }
        if (this.force != null) {
            arg.add(String.format("force: %s", this.force));
        }
        if (arg.size() > 0) {
            return String.format("group:{%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
        }
        return "";
    }

    GroupArgument(GroupType type, Float force) {
        this.type = type;
        this.force = force;
    }

    public static GroupArgumentBuilder builder() {
        return new GroupArgumentBuilder();
    }

    public GroupType getType() {
        return this.type;
    }

    public Float getForce() {
        return this.force;
    }

    public static class GroupArgumentBuilder {
        private GroupType type;
        private Float force;

        GroupArgumentBuilder() {
        }

        public GroupArgumentBuilder type(GroupType type) {
            this.type = type;
            return this;
        }

        public GroupArgumentBuilder force(Float force) {
            this.force = force;
            return this;
        }

        public GroupArgument build() {
            return new GroupArgument(this.type, this.force);
        }

        public String toString() {
            return "GroupArgument.GroupArgumentBuilder(type=" + (Object)((Object)this.type) + ", force=" + this.force + ")";
        }
    }
}

