/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.misc.model;

import technology.semi.weaviate.client.v1.misc.model.BM25Config;
import technology.semi.weaviate.client.v1.misc.model.StopwordConfig;

public class InvertedIndexConfig {
    private final BM25Config bm25;
    private final StopwordConfig stopwords;
    private final Integer cleanupIntervalSeconds;

    InvertedIndexConfig(BM25Config bm25, StopwordConfig stopwords, Integer cleanupIntervalSeconds) {
        this.bm25 = bm25;
        this.stopwords = stopwords;
        this.cleanupIntervalSeconds = cleanupIntervalSeconds;
    }

    public static InvertedIndexConfigBuilder builder() {
        return new InvertedIndexConfigBuilder();
    }

    public BM25Config getBm25() {
        return this.bm25;
    }

    public StopwordConfig getStopwords() {
        return this.stopwords;
    }

    public Integer getCleanupIntervalSeconds() {
        return this.cleanupIntervalSeconds;
    }

    public static class InvertedIndexConfigBuilder {
        private BM25Config bm25;
        private StopwordConfig stopwords;
        private Integer cleanupIntervalSeconds;

        InvertedIndexConfigBuilder() {
        }

        public InvertedIndexConfigBuilder bm25(BM25Config bm25) {
            this.bm25 = bm25;
            return this;
        }

        public InvertedIndexConfigBuilder stopwords(StopwordConfig stopwords) {
            this.stopwords = stopwords;
            return this;
        }

        public InvertedIndexConfigBuilder cleanupIntervalSeconds(Integer cleanupIntervalSeconds) {
            this.cleanupIntervalSeconds = cleanupIntervalSeconds;
            return this;
        }

        public InvertedIndexConfig build() {
            return new InvertedIndexConfig(this.bm25, this.stopwords, this.cleanupIntervalSeconds);
        }

        public String toString() {
            return "InvertedIndexConfig.InvertedIndexConfigBuilder(bm25=" + this.bm25 + ", stopwords=" + this.stopwords + ", cleanupIntervalSeconds=" + this.cleanupIntervalSeconds + ")";
        }
    }
}

