// Generated by delombok at Wed May 04 09:28:17 UTC 2022
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AskArgument implements Argument {
  private final String question;
  private final String[] properties;
  private final Float certainty;
  private final Boolean autocorrect;
  private final Boolean rerank;

  @Override
  public String build() {
    Set<String> arg = new LinkedHashSet<>();
    if (StringUtils.isNotBlank(question)) {
      arg.add(String.format("question: \"%s\"", question));
    }
    if (properties != null && properties.length > 0) {
      String props = Stream.of(properties).map(f -> String.format("\"%s\"", f)).collect(Collectors.joining(", "));
      arg.add(String.format("properties: [%s]", props));
    }
    if (certainty != null) {
      arg.add(String.format("certainty: %s", certainty));
    }
    if (autocorrect != null) {
      arg.add(String.format("autocorrect: %s", autocorrect));
    }
    if (rerank != null) {
      arg.add(String.format("rerank: %s", rerank));
    }
    return String.format("ask: {%s}", StringUtils.joinWith(" ", arg.toArray()));
  }

  @java.lang.SuppressWarnings("all")
  AskArgument(final String question, final String[] properties, final Float certainty, final Boolean autocorrect, final Boolean rerank) {
    this.question = question;
    this.properties = properties;
    this.certainty = certainty;
    this.autocorrect = autocorrect;
    this.rerank = rerank;
  }


  @java.lang.SuppressWarnings("all")
  public static class AskArgumentBuilder {
    @java.lang.SuppressWarnings("all")
    private String question;
    @java.lang.SuppressWarnings("all")
    private String[] properties;
    @java.lang.SuppressWarnings("all")
    private Float certainty;
    @java.lang.SuppressWarnings("all")
    private Boolean autocorrect;
    @java.lang.SuppressWarnings("all")
    private Boolean rerank;

    @java.lang.SuppressWarnings("all")
    AskArgumentBuilder() {
    }

    @java.lang.SuppressWarnings("all")
    public AskArgument.AskArgumentBuilder question(final String question) {
      this.question = question;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AskArgument.AskArgumentBuilder properties(final String[] properties) {
      this.properties = properties;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AskArgument.AskArgumentBuilder certainty(final Float certainty) {
      this.certainty = certainty;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AskArgument.AskArgumentBuilder autocorrect(final Boolean autocorrect) {
      this.autocorrect = autocorrect;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AskArgument.AskArgumentBuilder rerank(final Boolean rerank) {
      this.rerank = rerank;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AskArgument build() {
      return new AskArgument(this.question, this.properties, this.certainty, this.autocorrect, this.rerank);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "AskArgument.AskArgumentBuilder(question=" + this.question + ", properties=" + java.util.Arrays.deepToString(this.properties) + ", certainty=" + this.certainty + ", autocorrect=" + this.autocorrect + ", rerank=" + this.rerank + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static AskArgument.AskArgumentBuilder builder() {
    return new AskArgument.AskArgumentBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getQuestion() {
    return this.question;
  }

  @java.lang.SuppressWarnings("all")
  public String[] getProperties() {
    return this.properties;
  }

  @java.lang.SuppressWarnings("all")
  public Float getCertainty() {
    return this.certainty;
  }

  @java.lang.SuppressWarnings("all")
  public Boolean getAutocorrect() {
    return this.autocorrect;
  }

  @java.lang.SuppressWarnings("all")
  public Boolean getRerank() {
    return this.rerank;
  }
}
