/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;

public class NearObjectArgument
implements Argument {
    private final String id;
    private final String beacon;
    private final Float certainty;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            arg.add(String.format("id: \"%s\"", this.id));
        }
        if (StringUtils.isNotBlank((CharSequence)this.beacon)) {
            arg.add(String.format("beacon: \"%s\"", this.beacon));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty: %s", this.certainty));
        }
        return String.format("nearObject: {%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    NearObjectArgument(String id, String beacon, Float certainty) {
        this.id = id;
        this.beacon = beacon;
        this.certainty = certainty;
    }

    public static NearObjectArgumentBuilder builder() {
        return new NearObjectArgumentBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getBeacon() {
        return this.beacon;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public static class NearObjectArgumentBuilder {
        private String id;
        private String beacon;
        private Float certainty;

        NearObjectArgumentBuilder() {
        }

        public NearObjectArgumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public NearObjectArgumentBuilder beacon(String beacon) {
            this.beacon = beacon;
            return this;
        }

        public NearObjectArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearObjectArgument build() {
            return new NearObjectArgument(this.id, this.beacon, this.certainty);
        }

        public String toString() {
            return "NearObjectArgument.NearObjectArgumentBuilder(id=" + this.id + ", beacon=" + this.beacon + ", certainty=" + this.certainty + ")";
        }
    }
}

