// Generated by delombok at Tue Jul 12 08:08:04 UTC 2022
package technology.semi.weaviate.client.v1.graphql.query.builder;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.filters.WhereFilter;
import technology.semi.weaviate.client.v1.filters.WhereFilterUtil;
import technology.semi.weaviate.client.v1.graphql.query.argument.AskArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;
import java.util.LinkedHashSet;
import java.util.Set;

public class AggregateBuilder implements Query {
  private final String className;
  private final Fields fields;
  private final String groupByClausePropertyName;
  private final WhereFilter withWhereFilter;
  private final NearTextArgument withNearTextFilter;
  private final NearObjectArgument withNearObjectFilter;
  private final NearVectorArgument withNearVectorFilter;
  private final AskArgument withAskArgument;
  private final NearImageArgument withNearImageFilter;
  private final Integer objectLimit;
  private final Integer limit;

  private boolean includesFilterClause() {
    return ObjectUtils.anyNotNull(withWhereFilter, withNearTextFilter, withNearObjectFilter, withNearVectorFilter, objectLimit, withAskArgument, withNearImageFilter, limit) || StringUtils.isNotBlank(groupByClausePropertyName);
  }

  private String createFilterClause() {
    if (includesFilterClause()) {
      Set<String> filters = new LinkedHashSet<>();
      if (StringUtils.isNotBlank(groupByClausePropertyName)) {
        filters.add(String.format("groupBy: \"%s\"", groupByClausePropertyName));
      }
      if (withWhereFilter != null) {
        filters.add(WhereFilterUtil.toGraphQLString(withWhereFilter));
      }
      if (withNearTextFilter != null) {
        filters.add(withNearTextFilter.build());
      }
      if (withNearObjectFilter != null) {
        filters.add(withNearObjectFilter.build());
      }
      if (withNearVectorFilter != null) {
        filters.add(withNearVectorFilter.build());
      }
      if (withAskArgument != null) {
        filters.add(withAskArgument.build());
      }
      if (withNearImageFilter != null) {
        filters.add(withNearImageFilter.build());
      }
      if (limit != null) {
        filters.add(String.format("limit: %s", limit));
      }
      if (objectLimit != null) {
        filters.add(String.format("objectLimit: %s", objectLimit));
      }
      return String.format("(%s)", StringUtils.joinWith(", ", filters.toArray()));
    }
    return "";
  }

  @Override
  public String buildQuery() {
    String fieldsClause = fields != null ? fields.build() : "";
    return String.format("{Aggregate{%s%s{%s}}}", className, createFilterClause(), fieldsClause);
  }

  @java.lang.SuppressWarnings("all")
  AggregateBuilder(final String className, final Fields fields, final String groupByClausePropertyName, final WhereFilter withWhereFilter, final NearTextArgument withNearTextFilter, final NearObjectArgument withNearObjectFilter, final NearVectorArgument withNearVectorFilter, final AskArgument withAskArgument, final NearImageArgument withNearImageFilter, final Integer objectLimit, final Integer limit) {
    this.className = className;
    this.fields = fields;
    this.groupByClausePropertyName = groupByClausePropertyName;
    this.withWhereFilter = withWhereFilter;
    this.withNearTextFilter = withNearTextFilter;
    this.withNearObjectFilter = withNearObjectFilter;
    this.withNearVectorFilter = withNearVectorFilter;
    this.withAskArgument = withAskArgument;
    this.withNearImageFilter = withNearImageFilter;
    this.objectLimit = objectLimit;
    this.limit = limit;
  }


  @java.lang.SuppressWarnings("all")
  public static class AggregateBuilderBuilder {
    @java.lang.SuppressWarnings("all")
    private String className;
    @java.lang.SuppressWarnings("all")
    private Fields fields;
    @java.lang.SuppressWarnings("all")
    private String groupByClausePropertyName;
    @java.lang.SuppressWarnings("all")
    private WhereFilter withWhereFilter;
    @java.lang.SuppressWarnings("all")
    private NearTextArgument withNearTextFilter;
    @java.lang.SuppressWarnings("all")
    private NearObjectArgument withNearObjectFilter;
    @java.lang.SuppressWarnings("all")
    private NearVectorArgument withNearVectorFilter;
    @java.lang.SuppressWarnings("all")
    private AskArgument withAskArgument;
    @java.lang.SuppressWarnings("all")
    private NearImageArgument withNearImageFilter;
    @java.lang.SuppressWarnings("all")
    private Integer objectLimit;
    @java.lang.SuppressWarnings("all")
    private Integer limit;

    @java.lang.SuppressWarnings("all")
    AggregateBuilderBuilder() {
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder className(final String className) {
      this.className = className;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder fields(final Fields fields) {
      this.fields = fields;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder groupByClausePropertyName(final String groupByClausePropertyName) {
      this.groupByClausePropertyName = groupByClausePropertyName;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withWhereFilter(final WhereFilter withWhereFilter) {
      this.withWhereFilter = withWhereFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearTextFilter(final NearTextArgument withNearTextFilter) {
      this.withNearTextFilter = withNearTextFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearObjectFilter(final NearObjectArgument withNearObjectFilter) {
      this.withNearObjectFilter = withNearObjectFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearVectorFilter(final NearVectorArgument withNearVectorFilter) {
      this.withNearVectorFilter = withNearVectorFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withAskArgument(final AskArgument withAskArgument) {
      this.withAskArgument = withAskArgument;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearImageFilter(final NearImageArgument withNearImageFilter) {
      this.withNearImageFilter = withNearImageFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder objectLimit(final Integer objectLimit) {
      this.objectLimit = objectLimit;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder limit(final Integer limit) {
      this.limit = limit;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder build() {
      return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName, this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withAskArgument, this.withNearImageFilter, this.objectLimit, this.limit);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ", withWhereFilter=" + this.withWhereFilter + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", objectLimit=" + this.objectLimit + ", limit=" + this.limit + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static AggregateBuilder.AggregateBuilderBuilder builder() {
    return new AggregateBuilder.AggregateBuilderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getClassName() {
    return this.className;
  }

  @java.lang.SuppressWarnings("all")
  public Fields getFields() {
    return this.fields;
  }

  @java.lang.SuppressWarnings("all")
  public String getGroupByClausePropertyName() {
    return this.groupByClausePropertyName;
  }

  @java.lang.SuppressWarnings("all")
  public WhereFilter getWithWhereFilter() {
    return this.withWhereFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextArgument getWithNearTextFilter() {
    return this.withNearTextFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearObjectArgument getWithNearObjectFilter() {
    return this.withNearObjectFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearVectorArgument getWithNearVectorFilter() {
    return this.withNearVectorFilter;
  }

  @java.lang.SuppressWarnings("all")
  public AskArgument getWithAskArgument() {
    return this.withAskArgument;
  }

  @java.lang.SuppressWarnings("all")
  public NearImageArgument getWithNearImageFilter() {
    return this.withNearImageFilter;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getObjectLimit() {
    return this.objectLimit;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getLimit() {
    return this.limit;
  }
}
