/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.data.util;

import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.base.util.DbVersionSupport;

public class ReferencesPath {
    private final DbVersionSupport support;

    public ReferencesPath(DbVersionSupport support) {
        this.support = support;
    }

    public String build(Params pathParams) {
        StringBuilder path = new StringBuilder("/objects");
        if (pathParams != null) {
            if (this.support.supportsClassNameNamespacedEndpoints()) {
                if (StringUtils.isNotBlank((CharSequence)pathParams.className)) {
                    path.append("/").append(StringUtils.trim((String)pathParams.className));
                } else {
                    this.support.warnDeprecatedNonClassNameNamespacedEndpointsForReferences();
                }
            } else if (StringUtils.isNotBlank((CharSequence)pathParams.className)) {
                this.support.warnNotSupportedClassNamespacedEndpointsForReferences();
            }
            if (StringUtils.isNotBlank((CharSequence)pathParams.id)) {
                path.append("/").append(StringUtils.trim((String)pathParams.id));
            }
            path.append("/references");
            if (StringUtils.isNotBlank((CharSequence)pathParams.property)) {
                path.append("/").append(StringUtils.trim((String)pathParams.property));
            }
        }
        return path.toString();
    }

    public static class Params {
        private final String id;
        private final String className;
        private final String property;

        Params(String id, String className, String property) {
            this.id = id;
            this.className = className;
            this.property = property;
        }

        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        public static class ParamsBuilder {
            private String id;
            private String className;
            private String property;

            ParamsBuilder() {
            }

            public ParamsBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ParamsBuilder className(String className) {
                this.className = className;
                return this;
            }

            public ParamsBuilder property(String property) {
                this.property = property;
                return this;
            }

            public Params build() {
                return new Params(this.id, this.className, this.property);
            }

            public String toString() {
                return "ReferencesPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", property=" + this.property + ")";
            }
        }
    }
}

