/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.misc.model;

public class ShardingConfig {
    private final Integer actualCount;
    private final Integer actualVirtualCount;
    private final Integer desiredCount;
    private final Integer desiredVirtualCount;
    private final String function;
    private final String key;
    private final String strategy;
    private final Integer virtualPerPhysical;

    ShardingConfig(Integer actualCount, Integer actualVirtualCount, Integer desiredCount, Integer desiredVirtualCount, String function, String key, String strategy, Integer virtualPerPhysical) {
        this.actualCount = actualCount;
        this.actualVirtualCount = actualVirtualCount;
        this.desiredCount = desiredCount;
        this.desiredVirtualCount = desiredVirtualCount;
        this.function = function;
        this.key = key;
        this.strategy = strategy;
        this.virtualPerPhysical = virtualPerPhysical;
    }

    public static ShardingConfigBuilder builder() {
        return new ShardingConfigBuilder();
    }

    public Integer getActualCount() {
        return this.actualCount;
    }

    public Integer getActualVirtualCount() {
        return this.actualVirtualCount;
    }

    public Integer getDesiredCount() {
        return this.desiredCount;
    }

    public Integer getDesiredVirtualCount() {
        return this.desiredVirtualCount;
    }

    public String getFunction() {
        return this.function;
    }

    public String getKey() {
        return this.key;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public Integer getVirtualPerPhysical() {
        return this.virtualPerPhysical;
    }

    public static class ShardingConfigBuilder {
        private Integer actualCount;
        private Integer actualVirtualCount;
        private Integer desiredCount;
        private Integer desiredVirtualCount;
        private String function;
        private String key;
        private String strategy;
        private Integer virtualPerPhysical;

        ShardingConfigBuilder() {
        }

        public ShardingConfigBuilder actualCount(Integer actualCount) {
            this.actualCount = actualCount;
            return this;
        }

        public ShardingConfigBuilder actualVirtualCount(Integer actualVirtualCount) {
            this.actualVirtualCount = actualVirtualCount;
            return this;
        }

        public ShardingConfigBuilder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public ShardingConfigBuilder desiredVirtualCount(Integer desiredVirtualCount) {
            this.desiredVirtualCount = desiredVirtualCount;
            return this;
        }

        public ShardingConfigBuilder function(String function) {
            this.function = function;
            return this;
        }

        public ShardingConfigBuilder key(String key) {
            this.key = key;
            return this;
        }

        public ShardingConfigBuilder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        public ShardingConfigBuilder virtualPerPhysical(Integer virtualPerPhysical) {
            this.virtualPerPhysical = virtualPerPhysical;
            return this;
        }

        public ShardingConfig build() {
            return new ShardingConfig(this.actualCount, this.actualVirtualCount, this.desiredCount, this.desiredVirtualCount, this.function, this.key, this.strategy, this.virtualPerPhysical);
        }

        public String toString() {
            return "ShardingConfig.ShardingConfigBuilder(actualCount=" + this.actualCount + ", actualVirtualCount=" + this.actualVirtualCount + ", desiredCount=" + this.desiredCount + ", desiredVirtualCount=" + this.desiredVirtualCount + ", function=" + this.function + ", key=" + this.key + ", strategy=" + this.strategy + ", virtualPerPhysical=" + this.virtualPerPhysical + ")";
        }
    }
}

