// Generated by delombok at Thu Sep 29 06:54:17 UTC 2022
package technology.semi.weaviate.client.v1.data.util;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.base.util.DbVersionSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

public class ObjectsPath {
  private final DbVersionSupport support;

  public ObjectsPath(DbVersionSupport support) {
    this.support = support;
  }

  public String buildCreate(Params pathParams) {
    return build(pathParams);
  }

  public String buildDelete(Params pathParams) {
    return build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId);
  }

  public String buildCheck(Params pathParams) {
    return build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId);
  }

  public String buildGetOne(Params pathParams) {
    return build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId, this::addQueryParamsForGetOne);
  }

  public String buildGet(Params pathParams) {
    return build(pathParams, this::addQueryParams);
  }

  public String buildUpdate(Params pathParams) {
    return build(pathParams, this::addClassNameDeprecatedCheck, this::addId);
  }

  @SafeVarargs
  private final String build(Params pathParams, BiConsumer<StringBuilder, Params>... modifiers) {
    Objects.requireNonNull(pathParams);
    StringBuilder path = new StringBuilder("/objects");
    Arrays.stream(modifiers).forEach(consumer -> consumer.accept(path, pathParams));
    return path.toString();
  }

  private void addClassNameDeprecatedNotSupportedCheck(StringBuilder path, Params pathParams) {
    if (support.supportsClassNameNamespacedEndpoints()) {
      if (StringUtils.isNotBlank(pathParams.className)) {
        path.append("/").append(StringUtils.trim(pathParams.className));
      } else {
        support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
      }
    } else if (StringUtils.isNotBlank(pathParams.className)) {
      support.warnNotSupportedClassNamespacedEndpointsForObjects();
    }
  }

  private void addClassNameDeprecatedCheck(StringBuilder path, Params pathParams) {
    if (support.supportsClassNameNamespacedEndpoints()) {
      if (StringUtils.isNotBlank(pathParams.className)) {
        path.append("/").append(StringUtils.trim(pathParams.className));
      } else {
        support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
      }
    }
  }

  private void addId(StringBuilder path, Params pathParams) {
    if (StringUtils.isNotBlank(pathParams.id)) {
      path.append("/").append(StringUtils.trim(pathParams.id));
    }
  }

  private void addQueryParams(StringBuilder path, Params pathParams) {
    List<String> queryParams = new ArrayList<>();
    if (ObjectUtils.isNotEmpty(pathParams.additional)) {
      queryParams.add(String.format("include=%s", StringUtils.join(pathParams.additional, ",")));
    }
    if (pathParams.limit != null) {
      queryParams.add(String.format("limit=%s", pathParams.limit));
    }
    if (StringUtils.isBlank(pathParams.id) && StringUtils.isNotBlank(pathParams.className)) {
      if (support.supportsClassNameNamespacedEndpoints()) {
        queryParams.add(String.format("class=%s", pathParams.className));
      } else {
        support.warnNotSupportedClassParameterInEndpointsForObjects();
      }
    }
    if (queryParams.size() > 0) {
      path.append("?").append(StringUtils.joinWith("&", queryParams.toArray()));
    }
  }

  private void addQueryParamsForGetOne(StringBuilder path, Params pathParams) {
    List<String> queryParams = new ArrayList<>();
    if (ObjectUtils.isNotEmpty(pathParams.additional)) {
      queryParams.add(String.format("include=%s", StringUtils.join(pathParams.additional, ",")));
    }
    if (queryParams.size() > 0) {
      path.append("?").append(StringUtils.joinWith("&", queryParams.toArray()));
    }
  }


  public static class Params {
    private final String id;
    private final String className;
    private final Integer limit;
    private final String[] additional;

    @java.lang.SuppressWarnings("all")
    Params(final String id, final String className, final Integer limit, final String[] additional) {
      this.id = id;
      this.className = className;
      this.limit = limit;
      this.additional = additional;
    }


    @java.lang.SuppressWarnings("all")
    public static class ParamsBuilder {
      @java.lang.SuppressWarnings("all")
      private String id;
      @java.lang.SuppressWarnings("all")
      private String className;
      @java.lang.SuppressWarnings("all")
      private Integer limit;
      @java.lang.SuppressWarnings("all")
      private String[] additional;

      @java.lang.SuppressWarnings("all")
      ParamsBuilder() {
      }

      @java.lang.SuppressWarnings("all")
      public ObjectsPath.Params.ParamsBuilder id(final String id) {
        this.id = id;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public ObjectsPath.Params.ParamsBuilder className(final String className) {
        this.className = className;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public ObjectsPath.Params.ParamsBuilder limit(final Integer limit) {
        this.limit = limit;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public ObjectsPath.Params.ParamsBuilder additional(final String[] additional) {
        this.additional = additional;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public ObjectsPath.Params build() {
        return new ObjectsPath.Params(this.id, this.className, this.limit, this.additional);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "ObjectsPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", limit=" + this.limit + ", additional=" + java.util.Arrays.deepToString(this.additional) + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static ObjectsPath.Params.ParamsBuilder builder() {
      return new ObjectsPath.Params.ParamsBuilder();
    }
  }
}
