/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client;

import java.util.Optional;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.util.DbVersionProvider;
import technology.semi.weaviate.client.base.util.DbVersionSupport;
import technology.semi.weaviate.client.v1.backup.Backup;
import technology.semi.weaviate.client.v1.batch.Batch;
import technology.semi.weaviate.client.v1.classifications.Classifications;
import technology.semi.weaviate.client.v1.contextionary.Contextionary;
import technology.semi.weaviate.client.v1.data.Data;
import technology.semi.weaviate.client.v1.graphql.GraphQL;
import technology.semi.weaviate.client.v1.misc.Misc;
import technology.semi.weaviate.client.v1.misc.api.MetaGetter;
import technology.semi.weaviate.client.v1.misc.model.Meta;
import technology.semi.weaviate.client.v1.schema.Schema;

public class WeaviateClient {
    private final Config config;
    private final DbVersionProvider dbVersionProvider;
    private final DbVersionSupport dbVersionSupport;

    public WeaviateClient(Config config) {
        this.config = config;
        this.dbVersionProvider = this.initDbVersionProvider();
        this.dbVersionSupport = new DbVersionSupport(this.dbVersionProvider);
    }

    public Misc misc() {
        return new Misc(this.config, this.dbVersionProvider);
    }

    public Schema schema() {
        return new Schema(this.config);
    }

    public Data data() {
        this.dbVersionProvider.refresh();
        return new Data(this.config, this.dbVersionSupport);
    }

    public Batch batch() {
        this.dbVersionProvider.refresh();
        return new Batch(this.config, this.dbVersionSupport);
    }

    public Backup backup() {
        return new Backup(this.config);
    }

    public Contextionary c11y() {
        return new Contextionary(this.config);
    }

    public Classifications classifications() {
        return new Classifications(this.config);
    }

    public GraphQL graphQL() {
        return new GraphQL(this.config);
    }

    private DbVersionProvider initDbVersionProvider() {
        MetaGetter metaGetter = new Misc(this.config, null).metaGetter();
        DbVersionProvider.VersionGetter getter = () -> Optional.ofNullable(metaGetter.run()).filter(result -> !result.hasErrors()).map(result -> ((Meta)result.getResult()).getVersion());
        return new DbVersionProvider(getter);
    }
}

