/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.data.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.BaseClient;
import technology.semi.weaviate.client.base.ClientResult;
import technology.semi.weaviate.client.base.Response;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.v1.data.model.ObjectsListResponse;
import technology.semi.weaviate.client.v1.data.model.WeaviateObject;
import technology.semi.weaviate.client.v1.data.util.ObjectsPath;

public class ObjectsGetter
extends BaseClient<ObjectsListResponse>
implements ClientResult<List<WeaviateObject>> {
    private final ObjectsPath objectsPath;
    private String id;
    private String className;
    private Integer limit;
    private final HashSet<String> additional;
    private final ObjectGetter objectGetter;

    public ObjectsGetter(Config config, ObjectsPath objectsPath) {
        super(config);
        this.objectGetter = new ObjectGetter(config);
        this.additional = new HashSet();
        this.objectsPath = Objects.requireNonNull(objectsPath);
    }

    public ObjectsGetter withID(String id) {
        this.id = id;
        return this;
    }

    public ObjectsGetter withClassName(String className) {
        this.className = className;
        return this;
    }

    public ObjectsGetter withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public ObjectsGetter withVector() {
        this.additional.add("vector");
        return this;
    }

    public ObjectsGetter withAdditional(String name) {
        this.additional.add(name);
        return this;
    }

    @Override
    public Result<List<WeaviateObject>> run() {
        ObjectsPath.Params params = ObjectsPath.Params.builder().id(this.id).className(this.className).limit(this.limit).additional(this.additional.toArray(new String[0])).build();
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            return this.objectGetter.withPath(this.objectsPath.buildGetOne(params)).run();
        }
        Response<ObjectsListResponse> resp = this.sendGetRequest(this.objectsPath.buildGet(params), ObjectsListResponse.class);
        return new Result<List<WeaviateObject>>(resp.getStatusCode(), Arrays.asList(resp.getBody().getObjects()), resp.getErrors());
    }

    private class ObjectGetter
    extends BaseClient<WeaviateObject>
    implements ClientResult<List<WeaviateObject>> {
        private String path;

        public ObjectGetter(Config config) {
            super(config);
        }

        public ObjectGetter withPath(String path) {
            this.path = path;
            return this;
        }

        @Override
        public Result<List<WeaviateObject>> run() {
            Response<WeaviateObject> resp = this.sendGetRequest(this.path, WeaviateObject.class);
            return new Result<List<WeaviateObject>>(resp.getStatusCode(), Arrays.asList(resp.getBody()), resp.getErrors());
        }
    }
}

