// Generated by delombok at Fri Nov 18 20:33:19 UTC 2022
package technology.semi.weaviate.client.v1.graphql.query.builder;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.filters.WhereFilter;
import technology.semi.weaviate.client.v1.filters.WhereFilterUtil;
import technology.semi.weaviate.client.v1.graphql.query.argument.AskArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.GroupArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.SortArguments;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;
import java.util.LinkedHashSet;
import java.util.Set;

public class GetBuilder implements Query {
  private final String className;
  private final Fields fields;
  private final Integer offset;
  private final Integer limit;
  private final WhereFilter withWhereFilter;
  private final NearTextArgument withNearTextFilter;
  private final NearObjectArgument withNearObjectFilter;
  private final AskArgument withAskArgument;
  private final NearImageArgument withNearImageFilter;
  private final NearVectorArgument withNearVectorFilter;
  private final GroupArgument withGroupArgument;
  private final SortArguments withSortArguments;

  private boolean includesFilterClause() {
    return ObjectUtils.anyNotNull(withWhereFilter, withNearTextFilter, withNearObjectFilter, withNearVectorFilter, withNearImageFilter, withGroupArgument, withAskArgument, limit, offset, withSortArguments);
  }

  private String createFilterClause() {
    if (includesFilterClause()) {
      Set<String> filters = new LinkedHashSet<>();
      if (withWhereFilter != null) {
        filters.add(WhereFilterUtil.toGraphQLString(withWhereFilter));
      }
      if (withNearTextFilter != null) {
        filters.add(withNearTextFilter.build());
      }
      if (withNearObjectFilter != null) {
        filters.add(withNearObjectFilter.build());
      }
      if (withNearVectorFilter != null) {
        filters.add(withNearVectorFilter.build());
      }
      if (withGroupArgument != null) {
        filters.add(withGroupArgument.build());
      }
      if (withAskArgument != null) {
        filters.add(withAskArgument.build());
      }
      if (withNearImageFilter != null) {
        filters.add(withNearImageFilter.build());
      }
      if (limit != null) {
        filters.add(String.format("limit: %s", limit));
      }
      if (offset != null) {
        filters.add(String.format("offset: %s", offset));
      }
      if (withSortArguments != null) {
        filters.add(withSortArguments.build());
      }
      return String.format("(%s)", StringUtils.joinWith(", ", filters.toArray()));
    }
    return "";
  }

  private String createFields() {
    return fields != null ? fields.build() : "";
  }

  @Override
  public String buildQuery() {
    return String.format("{Get{%s%s{%s}}}", className, createFilterClause(), createFields());
  }

  @java.lang.SuppressWarnings("all")
  GetBuilder(final String className, final Fields fields, final Integer offset, final Integer limit, final WhereFilter withWhereFilter, final NearTextArgument withNearTextFilter, final NearObjectArgument withNearObjectFilter, final AskArgument withAskArgument, final NearImageArgument withNearImageFilter, final NearVectorArgument withNearVectorFilter, final GroupArgument withGroupArgument, final SortArguments withSortArguments) {
    this.className = className;
    this.fields = fields;
    this.offset = offset;
    this.limit = limit;
    this.withWhereFilter = withWhereFilter;
    this.withNearTextFilter = withNearTextFilter;
    this.withNearObjectFilter = withNearObjectFilter;
    this.withAskArgument = withAskArgument;
    this.withNearImageFilter = withNearImageFilter;
    this.withNearVectorFilter = withNearVectorFilter;
    this.withGroupArgument = withGroupArgument;
    this.withSortArguments = withSortArguments;
  }


  @java.lang.SuppressWarnings("all")
  public static class GetBuilderBuilder {
    @java.lang.SuppressWarnings("all")
    private String className;
    @java.lang.SuppressWarnings("all")
    private Fields fields;
    @java.lang.SuppressWarnings("all")
    private Integer offset;
    @java.lang.SuppressWarnings("all")
    private Integer limit;
    @java.lang.SuppressWarnings("all")
    private WhereFilter withWhereFilter;
    @java.lang.SuppressWarnings("all")
    private NearTextArgument withNearTextFilter;
    @java.lang.SuppressWarnings("all")
    private NearObjectArgument withNearObjectFilter;
    @java.lang.SuppressWarnings("all")
    private AskArgument withAskArgument;
    @java.lang.SuppressWarnings("all")
    private NearImageArgument withNearImageFilter;
    @java.lang.SuppressWarnings("all")
    private NearVectorArgument withNearVectorFilter;
    @java.lang.SuppressWarnings("all")
    private GroupArgument withGroupArgument;
    @java.lang.SuppressWarnings("all")
    private SortArguments withSortArguments;

    @java.lang.SuppressWarnings("all")
    GetBuilderBuilder() {
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder className(final String className) {
      this.className = className;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder fields(final Fields fields) {
      this.fields = fields;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder offset(final Integer offset) {
      this.offset = offset;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder limit(final Integer limit) {
      this.limit = limit;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withWhereFilter(final WhereFilter withWhereFilter) {
      this.withWhereFilter = withWhereFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearTextFilter(final NearTextArgument withNearTextFilter) {
      this.withNearTextFilter = withNearTextFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearObjectFilter(final NearObjectArgument withNearObjectFilter) {
      this.withNearObjectFilter = withNearObjectFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withAskArgument(final AskArgument withAskArgument) {
      this.withAskArgument = withAskArgument;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearImageFilter(final NearImageArgument withNearImageFilter) {
      this.withNearImageFilter = withNearImageFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearVectorFilter(final NearVectorArgument withNearVectorFilter) {
      this.withNearVectorFilter = withNearVectorFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withGroupArgument(final GroupArgument withGroupArgument) {
      this.withGroupArgument = withGroupArgument;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withSortArguments(final SortArguments withSortArguments) {
      this.withSortArguments = withSortArguments;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder build() {
      return new GetBuilder(this.className, this.fields, this.offset, this.limit, this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter, this.withGroupArgument, this.withSortArguments);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "GetBuilder.GetBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", offset=" + this.offset + ", limit=" + this.limit + ", withWhereFilter=" + this.withWhereFilter + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withGroupArgument=" + this.withGroupArgument + ", withSortArguments=" + this.withSortArguments + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static GetBuilder.GetBuilderBuilder builder() {
    return new GetBuilder.GetBuilderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getClassName() {
    return this.className;
  }

  @java.lang.SuppressWarnings("all")
  public Fields getFields() {
    return this.fields;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getOffset() {
    return this.offset;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getLimit() {
    return this.limit;
  }

  @java.lang.SuppressWarnings("all")
  public WhereFilter getWithWhereFilter() {
    return this.withWhereFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextArgument getWithNearTextFilter() {
    return this.withNearTextFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearObjectArgument getWithNearObjectFilter() {
    return this.withNearObjectFilter;
  }

  @java.lang.SuppressWarnings("all")
  public AskArgument getWithAskArgument() {
    return this.withAskArgument;
  }

  @java.lang.SuppressWarnings("all")
  public NearImageArgument getWithNearImageFilter() {
    return this.withNearImageFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearVectorArgument getWithNearVectorFilter() {
    return this.withNearVectorFilter;
  }

  @java.lang.SuppressWarnings("all")
  public GroupArgument getWithGroupArgument() {
    return this.withGroupArgument;
  }

  @java.lang.SuppressWarnings("all")
  public SortArguments getWithSortArguments() {
    return this.withSortArguments;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "GetBuilder(className=" + this.getClassName() + ", fields=" + this.getFields() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", withWhereFilter=" + this.getWithWhereFilter() + ", withNearTextFilter=" + this.getWithNearTextFilter() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withGroupArgument=" + this.getWithGroupArgument() + ", withSortArguments=" + this.getWithSortArguments() + ")";
  }
}
