/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.data.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.base.util.DbVersionSupport;

public class ObjectsPath {
    private final DbVersionSupport support;

    public ObjectsPath(DbVersionSupport support) {
        this.support = support;
    }

    public String buildCreate(Params pathParams) {
        return this.build(pathParams, new BiConsumer[0]);
    }

    public String buildDelete(Params pathParams) {
        return this.build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId);
    }

    public String buildCheck(Params pathParams) {
        return this.build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId);
    }

    public String buildGetOne(Params pathParams) {
        return this.build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId, this::addQueryParamsForGetOne);
    }

    public String buildGet(Params pathParams) {
        return this.build(pathParams, this::addQueryParams);
    }

    public String buildUpdate(Params pathParams) {
        return this.build(pathParams, this::addClassNameDeprecatedCheck, this::addId);
    }

    @SafeVarargs
    private final String build(Params pathParams, BiConsumer<StringBuilder, Params> ... modifiers) {
        Objects.requireNonNull(pathParams);
        StringBuilder path = new StringBuilder("/objects");
        Arrays.stream(modifiers).forEach(consumer -> consumer.accept(path, pathParams));
        return path.toString();
    }

    private void addClassNameDeprecatedNotSupportedCheck(StringBuilder path, Params pathParams) {
        if (this.support.supportsClassNameNamespacedEndpoints()) {
            if (StringUtils.isNotBlank((CharSequence)pathParams.className)) {
                path.append("/").append(StringUtils.trim((String)pathParams.className));
            } else {
                this.support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
            }
        } else if (StringUtils.isNotBlank((CharSequence)pathParams.className)) {
            this.support.warnNotSupportedClassNamespacedEndpointsForObjects();
        }
    }

    private void addClassNameDeprecatedCheck(StringBuilder path, Params pathParams) {
        if (this.support.supportsClassNameNamespacedEndpoints()) {
            if (StringUtils.isNotBlank((CharSequence)pathParams.className)) {
                path.append("/").append(StringUtils.trim((String)pathParams.className));
            } else {
                this.support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
            }
        }
    }

    private void addId(StringBuilder path, Params pathParams) {
        if (StringUtils.isNotBlank((CharSequence)pathParams.id)) {
            path.append("/").append(StringUtils.trim((String)pathParams.id));
        }
    }

    private void addQueryParams(StringBuilder path, Params pathParams) {
        ArrayList<String> queryParams = new ArrayList<String>();
        if (ObjectUtils.isNotEmpty((Object)pathParams.additional)) {
            queryParams.add(String.format("include=%s", StringUtils.join((Object[])pathParams.additional, (String)",")));
        }
        if (pathParams.limit != null) {
            queryParams.add(String.format("limit=%s", pathParams.limit));
        }
        if (StringUtils.isBlank((CharSequence)pathParams.id) && StringUtils.isNotBlank((CharSequence)pathParams.className)) {
            if (this.support.supportsClassNameNamespacedEndpoints()) {
                queryParams.add(String.format("class=%s", pathParams.className));
            } else {
                this.support.warnNotSupportedClassParameterInEndpointsForObjects();
            }
        }
        if (queryParams.size() > 0) {
            path.append("?").append(StringUtils.joinWith((String)"&", (Object[])queryParams.toArray()));
        }
    }

    private void addQueryParamsForGetOne(StringBuilder path, Params pathParams) {
        ArrayList<String> queryParams = new ArrayList<String>();
        if (ObjectUtils.isNotEmpty((Object)pathParams.additional)) {
            queryParams.add(String.format("include=%s", StringUtils.join((Object[])pathParams.additional, (String)",")));
        }
        if (queryParams.size() > 0) {
            path.append("?").append(StringUtils.joinWith((String)"&", (Object[])queryParams.toArray()));
        }
    }

    public static class Params {
        private final String id;
        private final String className;
        private final Integer limit;
        private final String[] additional;

        Params(String id, String className, Integer limit, String[] additional) {
            this.id = id;
            this.className = className;
            this.limit = limit;
            this.additional = additional;
        }

        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        public String toString() {
            return "ObjectsPath.Params(id=" + this.id + ", className=" + this.className + ", limit=" + this.limit + ", additional=" + Arrays.deepToString(this.additional) + ")";
        }

        public static class ParamsBuilder {
            private String id;
            private String className;
            private Integer limit;
            private String[] additional;

            ParamsBuilder() {
            }

            public ParamsBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ParamsBuilder className(String className) {
                this.className = className;
                return this;
            }

            public ParamsBuilder limit(Integer limit) {
                this.limit = limit;
                return this;
            }

            public ParamsBuilder additional(String[] additional) {
                this.additional = additional;
                return this;
            }

            public Params build() {
                return new Params(this.id, this.className, this.limit, this.additional);
            }

            public String toString() {
                return "ObjectsPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", limit=" + this.limit + ", additional=" + Arrays.deepToString(this.additional) + ")";
            }
        }
    }
}

