/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.filters;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import technology.semi.weaviate.client.v1.filters.WhereFilter;

public class WhereFilterUtil {
    public static String toGraphQLString(WhereFilter whereFilter) {
        String whereStr = whereFilter != null ? WhereFilterUtil.buildWhereFilter(whereFilter) : "";
        return String.format("where:{%s}", whereStr);
    }

    private static String buildWhereFilter(WhereFilter wf) {
        LinkedHashSet<String> args = new LinkedHashSet<String>();
        if (wf.getOperands() != null && wf.getOperands().length > 0) {
            if (wf.getOperator() != null) {
                args.add(WhereFilterUtil.buildArg("operator", wf.getOperator()));
            }
            String operands = Arrays.stream(wf.getOperands()).map(operand -> String.format("{%s}", WhereFilterUtil.buildWhereFilter(operand))).collect(Collectors.joining(","));
            args.add(String.format("operands:[%s]", operands));
        } else {
            if (wf.getPath() != null && wf.getPath().length > 0) {
                Object[] quoted = Arrays.stream(wf.getPath()).map(s -> String.format("\"%s\"", s)).toArray();
                args.add(String.format("path:[%s]", StringUtils.joinWith((String)",", (Object[])quoted)));
            }
            if (wf.getValueInt() != null) {
                args.add(WhereFilterUtil.buildArg("valueInt", wf.getValueInt()));
            }
            if (wf.getValueNumber() != null) {
                args.add(WhereFilterUtil.buildArg("valueNumber", wf.getValueNumber()));
            }
            if (wf.getValueBoolean() != null) {
                args.add(WhereFilterUtil.buildArg("valueBoolean", wf.getValueBoolean()));
            }
            if (wf.getValueString() != null) {
                args.add(WhereFilterUtil.buildArg("valueString", String.format("\"%s\"", wf.getValueString())));
            }
            if (wf.getValueText() != null) {
                args.add(WhereFilterUtil.buildArg("valueText", String.format("\"%s\"", wf.getValueText())));
            }
            if (wf.getValueDate() != null) {
                String date = DateFormatUtils.format((Date)wf.getValueDate(), (String)"yyyy-MM-dd'T'HH:mm:ssZZZZZ");
                args.add(WhereFilterUtil.buildArg("valueDate", String.format("\"%s\"", date)));
            }
            if (wf.getValueGeoRange() != null) {
                args.add(WhereFilterUtil.buildArg("valueGeoRange", WhereFilterUtil.buildGeoRange(wf.getValueGeoRange())));
            }
            if (wf.getOperator() != null) {
                args.add(WhereFilterUtil.buildArg("operator", wf.getOperator()));
            }
        }
        return StringUtils.joinWith((String)" ", (Object[])args.toArray());
    }

    private static String buildGeoRange(WhereFilter.GeoRange geoRange) {
        WhereFilter.GeoCoordinates geoCoordinates = geoRange.getGeoCoordinates();
        WhereFilter.GeoDistance distance = geoRange.getDistance();
        if (geoCoordinates != null && geoCoordinates.getLatitude() != null && geoCoordinates.getLongitude() != null && distance != null && distance.getMax() != null) {
            return String.format("{geoCoordinates:{latitude:%s,longitude:%s},distance:{max:%s}}", geoCoordinates.getLatitude(), geoCoordinates.getLongitude(), distance.getMax());
        }
        return "";
    }

    private static String buildArg(String name, Object value) {
        return String.format("%s:%s", name, value);
    }
}

