/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.backup.api;

import java.util.Arrays;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.BaseClient;
import technology.semi.weaviate.client.base.ClientResult;
import technology.semi.weaviate.client.base.Response;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.v1.backup.api.BackupRestoreStatusGetter;
import technology.semi.weaviate.client.v1.backup.model.BackupRestoreResponse;
import technology.semi.weaviate.client.v1.backup.model.BackupRestoreStatusResponse;

public class BackupRestorer
extends BaseClient<BackupRestoreResponse>
implements ClientResult<BackupRestoreResponse> {
    private static final long WAIT_INTERVAL = 1000L;
    private final BackupRestoreStatusGetter statusGetter;
    private String[] includeClassNames;
    private String[] excludeClassNames;
    private String backend;
    private String backupId;
    private boolean waitForCompletion;

    public BackupRestorer(Config config, BackupRestoreStatusGetter statusGetter) {
        super(config);
        this.statusGetter = statusGetter;
    }

    public BackupRestorer withIncludeClassNames(String ... classNames) {
        this.includeClassNames = classNames;
        return this;
    }

    public BackupRestorer withExcludeClassNames(String ... classNames) {
        this.excludeClassNames = classNames;
        return this;
    }

    public BackupRestorer withBackend(String backend) {
        this.backend = backend;
        return this;
    }

    @Deprecated
    public BackupRestorer backend(String backend) {
        return this.withBackend(backend);
    }

    public BackupRestorer withBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    public BackupRestorer withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    @Override
    public Result<BackupRestoreResponse> run() {
        BackupRestore payload = BackupRestore.builder().config(BackupRestoreConfig.builder().build()).include(this.includeClassNames).exclude(this.excludeClassNames).build();
        if (this.waitForCompletion) {
            return this.restoreAndWaitForCompletion(payload);
        }
        return this.restore(payload);
    }

    private Result<BackupRestoreResponse> restore(BackupRestore payload) {
        Response<BackupRestoreResponse> response = this.sendPostRequest(this.path(), payload, BackupRestoreResponse.class);
        return new Result<BackupRestoreResponse>(response);
    }

    private Result<BackupRestoreResponse> restoreAndWaitForCompletion(BackupRestore payload) {
        Result<BackupRestoreResponse> result = this.restore(payload);
        if (result.hasErrors()) {
            return result;
        }
        this.statusGetter.withBackend(this.backend).withBackupId(this.backupId);
        Response<BackupRestoreStatusResponse> statusResponse;
        while (!new Result<BackupRestoreStatusResponse>(statusResponse = this.statusGetter.statusRestore()).hasErrors()) {
            switch (statusResponse.getBody().getStatus()) {
                case "SUCCESS": 
                case "FAILED": {
                    return this.merge(statusResponse, result);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return this.merge(statusResponse, result);
            }
        }
        return this.merge(statusResponse, result);
    }

    private String path() {
        return String.format("/backups/%s/%s/restore", this.backend, this.backupId);
    }

    private Result<BackupRestoreResponse> merge(Response<BackupRestoreStatusResponse> response, Result<BackupRestoreResponse> result) {
        BackupRestoreStatusResponse statusRestoreResponse = response.getBody();
        BackupRestoreResponse restoreResponse = result.getResult();
        BackupRestoreResponse merged = null;
        if (statusRestoreResponse != null) {
            merged = new BackupRestoreResponse();
            merged.setId(statusRestoreResponse.getId());
            merged.setBackend(statusRestoreResponse.getBackend());
            merged.setPath(statusRestoreResponse.getPath());
            merged.setStatus(statusRestoreResponse.getStatus());
            merged.setError(statusRestoreResponse.getError());
            merged.setClassNames(restoreResponse.getClassNames());
        }
        return new Result<BackupRestoreResponse>(response.getStatusCode(), merged, response.getErrors());
    }

    private static class BackupRestoreConfig {
        BackupRestoreConfig() {
        }

        public static BackupRestoreConfigBuilder builder() {
            return new BackupRestoreConfigBuilder();
        }

        public static class BackupRestoreConfigBuilder {
            BackupRestoreConfigBuilder() {
            }

            public BackupRestoreConfig build() {
                return new BackupRestoreConfig();
            }

            public String toString() {
                return "BackupRestorer.BackupRestoreConfig.BackupRestoreConfigBuilder()";
            }
        }
    }

    private static class BackupRestore {
        BackupRestoreConfig config;
        String[] include;
        String[] exclude;

        BackupRestore(BackupRestoreConfig config, String[] include, String[] exclude) {
            this.config = config;
            this.include = include;
            this.exclude = exclude;
        }

        public static BackupRestoreBuilder builder() {
            return new BackupRestoreBuilder();
        }

        public BackupRestoreConfig getConfig() {
            return this.config;
        }

        public String[] getInclude() {
            return this.include;
        }

        public String[] getExclude() {
            return this.exclude;
        }

        public static class BackupRestoreBuilder {
            private BackupRestoreConfig config;
            private String[] include;
            private String[] exclude;

            BackupRestoreBuilder() {
            }

            public BackupRestoreBuilder config(BackupRestoreConfig config) {
                this.config = config;
                return this;
            }

            public BackupRestoreBuilder include(String[] include) {
                this.include = include;
                return this;
            }

            public BackupRestoreBuilder exclude(String[] exclude) {
                this.exclude = exclude;
                return this;
            }

            public BackupRestore build() {
                return new BackupRestore(this.config, this.include, this.exclude);
            }

            public String toString() {
                return "BackupRestorer.BackupRestore.BackupRestoreBuilder(config=" + this.config + ", include=" + Arrays.deepToString(this.include) + ", exclude=" + Arrays.deepToString(this.exclude) + ")";
            }
        }
    }
}

