/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.data.model;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Map;

public class WeaviateObject {
    private final String id;
    @SerializedName(value="class")
    private final String className;
    private final Long creationTimeUnix;
    private final Long lastUpdateTimeUnix;
    private final Map<String, Object> properties;
    private final Map<String, Object> additional;
    private final Float[] vector;
    private final Object vectorWeights;

    WeaviateObject(String id, String className, Long creationTimeUnix, Long lastUpdateTimeUnix, Map<String, Object> properties, Map<String, Object> additional, Float[] vector, Object vectorWeights) {
        this.id = id;
        this.className = className;
        this.creationTimeUnix = creationTimeUnix;
        this.lastUpdateTimeUnix = lastUpdateTimeUnix;
        this.properties = properties;
        this.additional = additional;
        this.vector = vector;
        this.vectorWeights = vectorWeights;
    }

    public static WeaviateObjectBuilder builder() {
        return new WeaviateObjectBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public Long getCreationTimeUnix() {
        return this.creationTimeUnix;
    }

    public Long getLastUpdateTimeUnix() {
        return this.lastUpdateTimeUnix;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getAdditional() {
        return this.additional;
    }

    public Float[] getVector() {
        return this.vector;
    }

    public Object getVectorWeights() {
        return this.vectorWeights;
    }

    public String toString() {
        return "WeaviateObject(id=" + this.getId() + ", className=" + this.getClassName() + ", creationTimeUnix=" + this.getCreationTimeUnix() + ", lastUpdateTimeUnix=" + this.getLastUpdateTimeUnix() + ", properties=" + this.getProperties() + ", additional=" + this.getAdditional() + ", vector=" + Arrays.deepToString(this.getVector()) + ", vectorWeights=" + this.getVectorWeights() + ")";
    }

    public static class WeaviateObjectBuilder {
        private String id;
        private String className;
        private Long creationTimeUnix;
        private Long lastUpdateTimeUnix;
        private Map<String, Object> properties;
        private Map<String, Object> additional;
        private Float[] vector;
        private Object vectorWeights;

        WeaviateObjectBuilder() {
        }

        public WeaviateObjectBuilder id(String id) {
            this.id = id;
            return this;
        }

        public WeaviateObjectBuilder className(String className) {
            this.className = className;
            return this;
        }

        public WeaviateObjectBuilder creationTimeUnix(Long creationTimeUnix) {
            this.creationTimeUnix = creationTimeUnix;
            return this;
        }

        public WeaviateObjectBuilder lastUpdateTimeUnix(Long lastUpdateTimeUnix) {
            this.lastUpdateTimeUnix = lastUpdateTimeUnix;
            return this;
        }

        public WeaviateObjectBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public WeaviateObjectBuilder additional(Map<String, Object> additional) {
            this.additional = additional;
            return this;
        }

        public WeaviateObjectBuilder vector(Float[] vector) {
            this.vector = vector;
            return this;
        }

        public WeaviateObjectBuilder vectorWeights(Object vectorWeights) {
            this.vectorWeights = vectorWeights;
            return this;
        }

        public WeaviateObject build() {
            return new WeaviateObject(this.id, this.className, this.creationTimeUnix, this.lastUpdateTimeUnix, this.properties, this.additional, this.vector, this.vectorWeights);
        }

        public String toString() {
            return "WeaviateObject.WeaviateObjectBuilder(id=" + this.id + ", className=" + this.className + ", creationTimeUnix=" + this.creationTimeUnix + ", lastUpdateTimeUnix=" + this.lastUpdateTimeUnix + ", properties=" + this.properties + ", additional=" + this.additional + ", vector=" + Arrays.deepToString(this.vector) + ", vectorWeights=" + this.vectorWeights + ")";
        }
    }
}

