/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.auth.provider;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.v1.auth.nimbus.BaseAuth;
import technology.semi.weaviate.client.v1.auth.nimbus.NimbusAuth;
import technology.semi.weaviate.client.v1.auth.provider.AccessTokenProvider;

public class AuthRefreshTokenProvider
implements AccessTokenProvider {
    private final NimbusAuth nimbusAuth = new NimbusAuth();
    private String accessToken;
    private ScheduledExecutorService executor;

    public AuthRefreshTokenProvider(Config config, BaseAuth.AuthResponse authResponse, String accessToken, long lifetimeSeconds, String refreshToken) {
        this.accessToken = accessToken;
        if (StringUtils.isNotBlank((CharSequence)refreshToken)) {
            this.scheduleRefreshTokenTask(config, authResponse, refreshToken, lifetimeSeconds);
        }
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    private void scheduleRefreshTokenTask(Config config, BaseAuth.AuthResponse authResponse, String refreshToken, long period) {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(() -> {
            this.accessToken = this.nimbusAuth.refreshToken(config, authResponse, refreshToken);
        }, period, period, TimeUnit.SECONDS);
    }
}

