/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;

public class HybridArgument
implements Argument {
    private final String query;
    private final Float alpha;
    private final Float[] vector;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        arg.add(String.format("query: \"%s\"", this.query));
        if (this.vector != null) {
            arg.add(String.format("vector: %s", Arrays.toString((Object[])this.vector)));
        }
        if (this.alpha != null) {
            arg.add(String.format("alpha: %s", this.alpha));
        }
        return String.format("hybrid: {%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    HybridArgument(String query, Float alpha, Float[] vector) {
        this.query = query;
        this.alpha = alpha;
        this.vector = vector;
    }

    public static HybridArgumentBuilder builder() {
        return new HybridArgumentBuilder();
    }

    public String getQuery() {
        return this.query;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public Float[] getVector() {
        return this.vector;
    }

    public static class HybridArgumentBuilder {
        private String query;
        private Float alpha;
        private Float[] vector;

        HybridArgumentBuilder() {
        }

        public HybridArgumentBuilder query(String query) {
            this.query = query;
            return this;
        }

        public HybridArgumentBuilder alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        public HybridArgumentBuilder vector(Float[] vector) {
            this.vector = vector;
            return this;
        }

        public HybridArgument build() {
            return new HybridArgument(this.query, this.alpha, this.vector);
        }

        public String toString() {
            return "HybridArgument.HybridArgumentBuilder(query=" + this.query + ", alpha=" + this.alpha + ", vector=" + Arrays.deepToString(this.vector) + ")";
        }
    }
}

