/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;

public class NearObjectArgument
implements Argument {
    private final String id;
    private final String beacon;
    private final Float certainty;
    private final Float distance;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            arg.add(String.format("id: \"%s\"", this.id));
        }
        if (StringUtils.isNotBlank((CharSequence)this.beacon)) {
            arg.add(String.format("beacon: \"%s\"", this.beacon));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty: %s", this.certainty));
        }
        if (this.distance != null) {
            arg.add(String.format("distance: %s", this.distance));
        }
        return String.format("nearObject: {%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    NearObjectArgument(String id, String beacon, Float certainty, Float distance) {
        this.id = id;
        this.beacon = beacon;
        this.certainty = certainty;
        this.distance = distance;
    }

    public static NearObjectArgumentBuilder builder() {
        return new NearObjectArgumentBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getBeacon() {
        return this.beacon;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public String toString() {
        return "NearObjectArgument(id=" + this.getId() + ", beacon=" + this.getBeacon() + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ")";
    }

    public static class NearObjectArgumentBuilder {
        private String id;
        private String beacon;
        private Float certainty;
        private Float distance;

        NearObjectArgumentBuilder() {
        }

        public NearObjectArgumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public NearObjectArgumentBuilder beacon(String beacon) {
            this.beacon = beacon;
            return this;
        }

        public NearObjectArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearObjectArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearObjectArgument build() {
            return new NearObjectArgument(this.id, this.beacon, this.certainty, this.distance);
        }

        public String toString() {
            return "NearObjectArgument.NearObjectArgumentBuilder(id=" + this.id + ", beacon=" + this.beacon + ", certainty=" + this.certainty + ", distance=" + this.distance + ")";
        }
    }
}

