/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.data.model;

import java.util.Arrays;
import technology.semi.weaviate.client.v1.data.model.Deprecation;
import technology.semi.weaviate.client.v1.data.model.WeaviateObject;

public class ObjectsListResponse {
    private final Deprecation[] deprecations;
    private final WeaviateObject[] objects;
    private final int totalResults;

    ObjectsListResponse(Deprecation[] deprecations, WeaviateObject[] objects, int totalResults) {
        this.deprecations = deprecations;
        this.objects = objects;
        this.totalResults = totalResults;
    }

    public static ObjectsListResponseBuilder builder() {
        return new ObjectsListResponseBuilder();
    }

    public Deprecation[] getDeprecations() {
        return this.deprecations;
    }

    public WeaviateObject[] getObjects() {
        return this.objects;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public String toString() {
        return "ObjectsListResponse(deprecations=" + Arrays.deepToString(this.getDeprecations()) + ", objects=" + Arrays.deepToString(this.getObjects()) + ", totalResults=" + this.getTotalResults() + ")";
    }

    public static class ObjectsListResponseBuilder {
        private Deprecation[] deprecations;
        private WeaviateObject[] objects;
        private int totalResults;

        ObjectsListResponseBuilder() {
        }

        public ObjectsListResponseBuilder deprecations(Deprecation[] deprecations) {
            this.deprecations = deprecations;
            return this;
        }

        public ObjectsListResponseBuilder objects(WeaviateObject[] objects) {
            this.objects = objects;
            return this;
        }

        public ObjectsListResponseBuilder totalResults(int totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ObjectsListResponse build() {
            return new ObjectsListResponse(this.deprecations, this.objects, this.totalResults);
        }

        public String toString() {
            return "ObjectsListResponse.ObjectsListResponseBuilder(deprecations=" + Arrays.deepToString(this.deprecations) + ", objects=" + Arrays.deepToString(this.objects) + ", totalResults=" + this.totalResults + ")";
        }
    }
}

