/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.fields;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;

public class Field
implements Argument {
    private final String name;
    private final Field[] fields;

    @Override
    public String build() {
        StringBuilder s = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            s.append(this.name);
        }
        if (this.fields != null && this.fields.length > 0) {
            s.append(String.format("{%s}", StringUtils.joinWith((String)" ", (Object[])Arrays.stream(this.fields).map(Field::build).toArray())));
        }
        return s.toString();
    }

    Field(String name, Field[] fields) {
        this.name = name;
        this.fields = fields;
    }

    public static FieldBuilder builder() {
        return new FieldBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String toString() {
        return "Field(name=" + this.getName() + ", fields=" + Arrays.deepToString(this.getFields()) + ")";
    }

    public static class FieldBuilder {
        private String name;
        private Field[] fields;

        FieldBuilder() {
        }

        public FieldBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FieldBuilder fields(Field[] fields) {
            this.fields = fields;
            return this;
        }

        public Field build() {
            return new Field(this.name, this.fields);
        }

        public String toString() {
            return "Field.FieldBuilder(name=" + this.name + ", fields=" + Arrays.deepToString(this.fields) + ")";
        }
    }
}

