// Generated by delombok at Thu Feb 23 13:54:59 UTC 2023
package technology.semi.weaviate.client.v1.backup.api;

import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.BaseClient;
import technology.semi.weaviate.client.base.ClientResult;
import technology.semi.weaviate.client.base.Response;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.base.http.HttpClient;
import technology.semi.weaviate.client.v1.backup.model.BackupCreateResponse;
import technology.semi.weaviate.client.v1.backup.model.BackupCreateStatusResponse;
import technology.semi.weaviate.client.v1.backup.model.CreateStatus;

public class BackupCreator extends BaseClient<BackupCreateResponse> implements ClientResult<BackupCreateResponse> {
  private static final long WAIT_INTERVAL = 1000;
  private final BackupCreateStatusGetter statusGetter;
  private String[] includeClassNames;
  private String[] excludeClassNames;
  private String backend;
  private String backupId;
  private boolean waitForCompletion;

  public BackupCreator(HttpClient httpClient, Config config, BackupCreateStatusGetter statusGetter) {
    super(httpClient, config);
    this.statusGetter = statusGetter;
  }

  public BackupCreator withIncludeClassNames(String... classNames) {
    this.includeClassNames = classNames;
    return this;
  }

  public BackupCreator withExcludeClassNames(String... classNames) {
    this.excludeClassNames = classNames;
    return this;
  }

  public BackupCreator withBackend(String backend) {
    this.backend = backend;
    return this;
  }

  public BackupCreator withBackupId(String backupId) {
    this.backupId = backupId;
    return this;
  }

  public BackupCreator withWaitForCompletion(boolean waitForCompletion) {
    this.waitForCompletion = waitForCompletion;
    return this;
  }

  @Override
  public Result<BackupCreateResponse> run() {
    BackupCreate payload = BackupCreate.builder().id(backupId).config(BackupCreateConfig.builder().build()).include(includeClassNames).exclude(excludeClassNames).build();
    if (waitForCompletion) {
      return createAndWaitForCompletion(payload);
    }
    return create(payload);
  }

  private Result<BackupCreateResponse> create(BackupCreate payload) {
    Response<BackupCreateResponse> response = sendPostRequest(path(), payload, BackupCreateResponse.class);
    return new Result<>(response);
  }

  private Result<BackupCreateResponse> createAndWaitForCompletion(BackupCreate payload) {
    Result<BackupCreateResponse> result = create(payload);
    if (result.hasErrors()) {
      return result;
    }
    statusGetter.withBackend(backend).withBackupId(backupId);
    while (true) {
      Response<BackupCreateStatusResponse> statusResponse = statusGetter.statusCreate();
      if (new Result<>(statusResponse).hasErrors()) {
        return merge(statusResponse, result);
      }
      switch (statusResponse.getBody().getStatus()) {
      case CreateStatus.SUCCESS: 
      case CreateStatus.FAILED: 
        return merge(statusResponse, result);
      }
      try {
        Thread.sleep(WAIT_INTERVAL);
      } catch (InterruptedException e) {
        return merge(statusResponse, result);
      }
    }
  }

  private String path() {
    return String.format("/backups/%s", backend);
  }

  private Result<BackupCreateResponse> merge(Response<BackupCreateStatusResponse> response, Result<BackupCreateResponse> result) {
    BackupCreateStatusResponse statusCreateResponse = response.getBody();
    BackupCreateResponse createResponse = result.getResult();
    BackupCreateResponse merged = null;
    if (statusCreateResponse != null) {
      merged = new BackupCreateResponse();
      merged.setId(statusCreateResponse.getId());
      merged.setBackend(statusCreateResponse.getBackend());
      merged.setPath(statusCreateResponse.getPath());
      merged.setStatus(statusCreateResponse.getStatus());
      merged.setError(statusCreateResponse.getError());
      merged.setClassNames(createResponse.getClassNames());
    }
    return new Result<>(response.getStatusCode(), merged, response.getErrors());
  }


  private static class BackupCreate {
    String id;
    BackupCreateConfig config;
    String[] include;
    String[] exclude;

    @java.lang.SuppressWarnings("all")
    BackupCreate(final String id, final BackupCreateConfig config, final String[] include, final String[] exclude) {
      this.id = id;
      this.config = config;
      this.include = include;
      this.exclude = exclude;
    }


    @java.lang.SuppressWarnings("all")
    public static class BackupCreateBuilder {
      @java.lang.SuppressWarnings("all")
      private String id;
      @java.lang.SuppressWarnings("all")
      private BackupCreateConfig config;
      @java.lang.SuppressWarnings("all")
      private String[] include;
      @java.lang.SuppressWarnings("all")
      private String[] exclude;

      @java.lang.SuppressWarnings("all")
      BackupCreateBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate.BackupCreateBuilder id(final String id) {
        this.id = id;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate.BackupCreateBuilder config(final BackupCreateConfig config) {
        this.config = config;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate.BackupCreateBuilder include(final String[] include) {
        this.include = include;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate.BackupCreateBuilder exclude(final String[] exclude) {
        this.exclude = exclude;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate build() {
        return new BackupCreator.BackupCreate(this.id, this.config, this.include, this.exclude);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "BackupCreator.BackupCreate.BackupCreateBuilder(id=" + this.id + ", config=" + this.config + ", include=" + java.util.Arrays.deepToString(this.include) + ", exclude=" + java.util.Arrays.deepToString(this.exclude) + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static BackupCreator.BackupCreate.BackupCreateBuilder builder() {
      return new BackupCreator.BackupCreate.BackupCreateBuilder();
    }

    @java.lang.SuppressWarnings("all")
    public String getId() {
      return this.id;
    }

    @java.lang.SuppressWarnings("all")
    public BackupCreateConfig getConfig() {
      return this.config;
    }

    @java.lang.SuppressWarnings("all")
    public String[] getInclude() {
      return this.include;
    }

    @java.lang.SuppressWarnings("all")
    public String[] getExclude() {
      return this.exclude;
    }
  }


  public static class BackupCreateConfig {
    @java.lang.SuppressWarnings("all")
    BackupCreateConfig() {
    }


    @java.lang.SuppressWarnings("all")
    public static class BackupCreateConfigBuilder {
      @java.lang.SuppressWarnings("all")
      BackupCreateConfigBuilder() {
      }

      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreateConfig build() {
        return new BackupCreator.BackupCreateConfig();
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder()";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder builder() {
      return new BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder();
    }
    // TBD
  }
}
