/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.backup.api;

import java.util.Arrays;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.BaseClient;
import technology.semi.weaviate.client.base.ClientResult;
import technology.semi.weaviate.client.base.Response;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.base.http.HttpClient;
import technology.semi.weaviate.client.v1.backup.api.BackupCreateStatusGetter;
import technology.semi.weaviate.client.v1.backup.model.BackupCreateResponse;
import technology.semi.weaviate.client.v1.backup.model.BackupCreateStatusResponse;

public class BackupCreator
extends BaseClient<BackupCreateResponse>
implements ClientResult<BackupCreateResponse> {
    private static final long WAIT_INTERVAL = 1000L;
    private final BackupCreateStatusGetter statusGetter;
    private String[] includeClassNames;
    private String[] excludeClassNames;
    private String backend;
    private String backupId;
    private boolean waitForCompletion;

    public BackupCreator(HttpClient httpClient, Config config, BackupCreateStatusGetter statusGetter) {
        super(httpClient, config);
        this.statusGetter = statusGetter;
    }

    public BackupCreator withIncludeClassNames(String ... classNames) {
        this.includeClassNames = classNames;
        return this;
    }

    public BackupCreator withExcludeClassNames(String ... classNames) {
        this.excludeClassNames = classNames;
        return this;
    }

    public BackupCreator withBackend(String backend) {
        this.backend = backend;
        return this;
    }

    public BackupCreator withBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    public BackupCreator withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    @Override
    public Result<BackupCreateResponse> run() {
        BackupCreate payload = BackupCreate.builder().id(this.backupId).config(BackupCreateConfig.builder().build()).include(this.includeClassNames).exclude(this.excludeClassNames).build();
        if (this.waitForCompletion) {
            return this.createAndWaitForCompletion(payload);
        }
        return this.create(payload);
    }

    private Result<BackupCreateResponse> create(BackupCreate payload) {
        Response<BackupCreateResponse> response = this.sendPostRequest(this.path(), payload, BackupCreateResponse.class);
        return new Result<BackupCreateResponse>(response);
    }

    private Result<BackupCreateResponse> createAndWaitForCompletion(BackupCreate payload) {
        Result<BackupCreateResponse> result = this.create(payload);
        if (result.hasErrors()) {
            return result;
        }
        this.statusGetter.withBackend(this.backend).withBackupId(this.backupId);
        Response<BackupCreateStatusResponse> statusResponse;
        while (!new Result<BackupCreateStatusResponse>(statusResponse = this.statusGetter.statusCreate()).hasErrors()) {
            switch (statusResponse.getBody().getStatus()) {
                case "SUCCESS": 
                case "FAILED": {
                    return this.merge(statusResponse, result);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return this.merge(statusResponse, result);
            }
        }
        return this.merge(statusResponse, result);
    }

    private String path() {
        return String.format("/backups/%s", this.backend);
    }

    private Result<BackupCreateResponse> merge(Response<BackupCreateStatusResponse> response, Result<BackupCreateResponse> result) {
        BackupCreateStatusResponse statusCreateResponse = response.getBody();
        BackupCreateResponse createResponse = result.getResult();
        BackupCreateResponse merged = null;
        if (statusCreateResponse != null) {
            merged = new BackupCreateResponse();
            merged.setId(statusCreateResponse.getId());
            merged.setBackend(statusCreateResponse.getBackend());
            merged.setPath(statusCreateResponse.getPath());
            merged.setStatus(statusCreateResponse.getStatus());
            merged.setError(statusCreateResponse.getError());
            merged.setClassNames(createResponse.getClassNames());
        }
        return new Result<BackupCreateResponse>(response.getStatusCode(), merged, response.getErrors());
    }

    public static class BackupCreateConfig {
        BackupCreateConfig() {
        }

        public static BackupCreateConfigBuilder builder() {
            return new BackupCreateConfigBuilder();
        }

        public static class BackupCreateConfigBuilder {
            BackupCreateConfigBuilder() {
            }

            public BackupCreateConfig build() {
                return new BackupCreateConfig();
            }

            public String toString() {
                return "BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder()";
            }
        }
    }

    private static class BackupCreate {
        String id;
        BackupCreateConfig config;
        String[] include;
        String[] exclude;

        BackupCreate(String id, BackupCreateConfig config, String[] include, String[] exclude) {
            this.id = id;
            this.config = config;
            this.include = include;
            this.exclude = exclude;
        }

        public static BackupCreateBuilder builder() {
            return new BackupCreateBuilder();
        }

        public String getId() {
            return this.id;
        }

        public BackupCreateConfig getConfig() {
            return this.config;
        }

        public String[] getInclude() {
            return this.include;
        }

        public String[] getExclude() {
            return this.exclude;
        }

        public static class BackupCreateBuilder {
            private String id;
            private BackupCreateConfig config;
            private String[] include;
            private String[] exclude;

            BackupCreateBuilder() {
            }

            public BackupCreateBuilder id(String id) {
                this.id = id;
                return this;
            }

            public BackupCreateBuilder config(BackupCreateConfig config) {
                this.config = config;
                return this;
            }

            public BackupCreateBuilder include(String[] include) {
                this.include = include;
                return this;
            }

            public BackupCreateBuilder exclude(String[] exclude) {
                this.exclude = exclude;
                return this;
            }

            public BackupCreate build() {
                return new BackupCreate(this.id, this.config, this.include, this.exclude);
            }

            public String toString() {
                return "BackupCreator.BackupCreate.BackupCreateBuilder(id=" + this.id + ", config=" + this.config + ", include=" + Arrays.deepToString(this.include) + ", exclude=" + Arrays.deepToString(this.exclude) + ")";
            }
        }
    }
}

