/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextMoveParameters;

public class NearTextArgument
implements Argument {
    private final String[] concepts;
    private final Float certainty;
    private final Float distance;
    private final NearTextMoveParameters moveTo;
    private final NearTextMoveParameters moveAwayFrom;
    private final Boolean autocorrect;

    private String getConcepts(String[] concepts) {
        return Stream.of(concepts).map(f -> String.format("\"%s\"", f)).collect(Collectors.joining(", "));
    }

    private String buildMoveParam(String name, NearTextMoveParameters moveParam) {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (ArrayUtils.isNotEmpty((Object[])moveParam.getConcepts())) {
            arg.add(String.format("concepts: [%s]", this.getConcepts(moveParam.getConcepts())));
        }
        if (moveParam.getForce() != null) {
            arg.add(String.format("force: %s", moveParam.getForce()));
        }
        if (ArrayUtils.isNotEmpty((Object[])moveParam.getObjects())) {
            String objects = Arrays.stream(moveParam.getObjects()).map(this::mapObjectMoveToStringClause).collect(Collectors.joining(","));
            arg.add(String.format("objects: [%s]", objects));
        }
        return String.format("%s: {%s}", name, StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    private String mapObjectMoveToStringClause(NearTextMoveParameters.ObjectMove obj) {
        LinkedHashSet<String> objectsArg = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)obj.getId())) {
            objectsArg.add(String.format("id: \"%s\"", obj.getId()));
        }
        if (StringUtils.isNotBlank((CharSequence)obj.getBeacon())) {
            objectsArg.add(String.format("beacon: \"%s\"", obj.getBeacon()));
        }
        return String.format("{%s}", StringUtils.joinWith((String)" ", (Object[])objectsArg.toArray()));
    }

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (this.concepts != null && this.concepts.length > 0) {
            arg.add(String.format("concepts: [%s]", this.getConcepts(this.concepts)));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty: %s", this.certainty));
        }
        if (this.distance != null) {
            arg.add(String.format("distance: %s", this.distance));
        }
        if (this.moveTo != null) {
            arg.add(this.buildMoveParam("moveTo", this.moveTo));
        }
        if (this.moveAwayFrom != null) {
            arg.add(this.buildMoveParam("moveAwayFrom", this.moveAwayFrom));
        }
        if (this.autocorrect != null) {
            arg.add(String.format("autocorrect: %s", this.autocorrect));
        }
        return String.format("nearText: {%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    NearTextArgument(String[] concepts, Float certainty, Float distance, NearTextMoveParameters moveTo, NearTextMoveParameters moveAwayFrom, Boolean autocorrect) {
        this.concepts = concepts;
        this.certainty = certainty;
        this.distance = distance;
        this.moveTo = moveTo;
        this.moveAwayFrom = moveAwayFrom;
        this.autocorrect = autocorrect;
    }

    public static NearTextArgumentBuilder builder() {
        return new NearTextArgumentBuilder();
    }

    public String[] getConcepts() {
        return this.concepts;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public NearTextMoveParameters getMoveTo() {
        return this.moveTo;
    }

    public NearTextMoveParameters getMoveAwayFrom() {
        return this.moveAwayFrom;
    }

    public Boolean getAutocorrect() {
        return this.autocorrect;
    }

    public String toString() {
        return "NearTextArgument(concepts=" + Arrays.deepToString(this.getConcepts()) + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", moveTo=" + this.getMoveTo() + ", moveAwayFrom=" + this.getMoveAwayFrom() + ", autocorrect=" + this.getAutocorrect() + ")";
    }

    public static class NearTextArgumentBuilder {
        private String[] concepts;
        private Float certainty;
        private Float distance;
        private NearTextMoveParameters moveTo;
        private NearTextMoveParameters moveAwayFrom;
        private Boolean autocorrect;

        NearTextArgumentBuilder() {
        }

        public NearTextArgumentBuilder concepts(String[] concepts) {
            this.concepts = concepts;
            return this;
        }

        public NearTextArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearTextArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearTextArgumentBuilder moveTo(NearTextMoveParameters moveTo) {
            this.moveTo = moveTo;
            return this;
        }

        public NearTextArgumentBuilder moveAwayFrom(NearTextMoveParameters moveAwayFrom) {
            this.moveAwayFrom = moveAwayFrom;
            return this;
        }

        public NearTextArgumentBuilder autocorrect(Boolean autocorrect) {
            this.autocorrect = autocorrect;
            return this;
        }

        public NearTextArgument build() {
            return new NearTextArgument(this.concepts, this.certainty, this.distance, this.moveTo, this.moveAwayFrom, this.autocorrect);
        }

        public String toString() {
            return "NearTextArgument.NearTextArgumentBuilder(concepts=" + Arrays.deepToString(this.concepts) + ", certainty=" + this.certainty + ", distance=" + this.distance + ", moveTo=" + this.moveTo + ", moveAwayFrom=" + this.moveAwayFrom + ", autocorrect=" + this.autocorrect + ")";
        }
    }
}

